/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.EnumUtils;

@XmlRootElement
public class APIProjectJobConfig
extends APIEntity {
    private String content;
    private Long frameworkId;
    private boolean global;
    private Date lastModificationTime;
    private String lastModifiedBy;
    private Type type;
    private Integer version;

    public APIProjectJobConfig() {
    }

    public APIProjectJobConfig(Long id, String type, String content, Integer version, boolean global, LocalDateTime lastModificationTime, String lastModifiedBy, Long frameworkId) {
        this(id, (Type)EnumUtils.getEnum(Type.class, (String)type), content, version, global, lastModificationTime, lastModifiedBy, frameworkId);
    }

    public APIProjectJobConfig(Long id, Type type, String content, Integer version, boolean global, LocalDateTime lastModificationTime, String lastModifiedBy, Long frameworkId) {
        super(id);
        this.type = type;
        this.content = content;
        this.version = version;
        this.global = global;
        this.lastModificationTime = TimeConverter.toDate(lastModificationTime);
        this.lastModifiedBy = lastModifiedBy;
        this.frameworkId = frameworkId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public Long getFrameworkId() {
        return this.frameworkId;
    }

    public void setFrameworkId(Long frameworkId) {
        this.frameworkId = frameworkId;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIProjectJobConfig apiProjectJobConfig = (APIProjectJobConfig)from;
        this.cloneBase(from);
        this.content = apiProjectJobConfig.content;
        this.type = apiProjectJobConfig.type;
        this.version = apiProjectJobConfig.version;
        this.global = apiProjectJobConfig.global;
        this.lastModificationTime = apiProjectJobConfig.lastModificationTime;
        this.lastModifiedBy = apiProjectJobConfig.lastModifiedBy;
        this.frameworkId = apiProjectJobConfig.frameworkId;
    }

    @XmlType(namespace="APIProjectJobConfig")
    public static enum Type {
        DESKTOP_BROWSER(APIDevice.OsType.DESKTOP, "Desktop Browser"),
        DESKTOP_BROWSER_SERVER_SIDE(APIDevice.OsType.DESKTOP, "Desktop Browser server side"),
        REMOTE(APIDevice.OsType.IOS, "Remote Device Session"),
        DEFAULT(APIDevice.OsType.ANDROID, "Android instrumentation"),
        INSTATEST(APIDevice.OsType.ANDROID, "Android App Crawler"),
        INTERACTIVE(APIDevice.OsType.ANDROID, "Testdroid Interactive"),
        INTERACTIVE_IOS(APIDevice.OsType.IOS, "Testdroid iOS Interactive"),
        CALABASH(APIDevice.OsType.ANDROID, "Android Calabash"),
        CALABASH_IOS(APIDevice.OsType.IOS, "iOS Calabash"),
        APPIUM_ANDROID_SERVER_SIDE(APIDevice.OsType.ANDROID, "Android Appium server side"),
        APPIUM_ANDROID(APIDevice.OsType.ANDROID, "Android Appium"),
        APPIUM_IOS(APIDevice.OsType.IOS, "iOS Appium"),
        APPIUM_IOS_SERVER_SIDE(APIDevice.OsType.IOS, "iOS Appium server side"),
        APPCRAWLER_IOS(APIDevice.OsType.IOS, "AppCrawler iOS"),
        XCTEST(APIDevice.OsType.IOS, "iOS XCTest"),
        XCUITEST(APIDevice.OsType.IOS, "iOS XCUITest"),
        GENERIC(APIDevice.OsType.UNDEFINED, "Undefined Framework");

        private final String name;
        private final APIDevice.OsType osType;

        private Type(APIDevice.OsType osType, String name) {
            this.osType = osType;
            this.name = name;
        }

        public APIDevice.OsType getOsType() {
            return this.osType;
        }

        public String getName() {
            return this.name;
        }
    }
}

