/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class APIRole
extends APIEntity {
    private String addedByEmail;
    private Date expireTime;
    private String name;
    private Integer value;
    private boolean valueCalculated;

    public APIRole() {
    }

    public APIRole(Long id, String name) {
        super(id);
        this.name = name;
    }

    public APIRole(Long id, String name, Integer value, boolean valueCalculated) {
        super(id);
        this.name = name;
        this.value = value;
        this.valueCalculated = valueCalculated;
    }

    public APIRole(Long id, String name, LocalDateTime expireTime, Integer value) {
        this(id, name, value, false);
        this.expireTime = TimeConverter.toDate(expireTime);
    }

    public APIRole(Long id, String name, LocalDateTime expireTime, String addedByEmail, Integer value) {
        this(id, name, expireTime, value);
        this.addedByEmail = addedByEmail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getAddedByEmail() {
        return this.addedByEmail;
    }

    public void setAddedByEmail(String addedByEmail) {
        this.addedByEmail = addedByEmail;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean isValueCalculated() {
        return this.valueCalculated;
    }

    public void setValueCalculated(boolean valueCalculated) {
        this.valueCalculated = valueCalculated;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIRole apiRole = (APIRole)from;
        this.cloneBase(from);
        this.expireTime = apiRole.expireTime;
        this.name = apiRole.name;
        this.addedByEmail = apiRole.addedByEmail;
        this.value = apiRole.value;
        this.valueCalculated = apiRole.valueCalculated;
    }
}

