/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIDeviceSession;
import com.testdroid.api.model.APITag;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUserFile;
import com.testdroid.api.util.TimeConverter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
public class APITestRun
extends APIEntity {
    private APITestRunConfig config;
    private Date createTime;
    private String displayName;
    private Integer errorsDeviceCount;
    private Integer excludedDeviceCount;
    private Float executionRatio;
    private Integer finishedDeviceCount;
    private Long logsFileId;
    private Integer number;
    private Long projectId;
    private Long screenshotsFileId;
    private String startedByDisplayName;
    private Long startedById;
    private State state;
    private Float successRatio;
    private Integer successfulTestCaseCount;
    private Integer failedTestCaseCount;
    private Integer executedTestCaseCount;
    private Integer testCaseCount;
    private Integer totalDeviceCount;
    private Integer warningDeviceCount;
    private Integer runningDeviceCount;
    private Integer succeededDeviceCount;
    private Integer waitingDeviceCount;
    private Integer abortedDeviceCount;
    private Integer timeoutedDeviceCount;
    private Long userId;
    private Long frameworkId;
    private String frameworkName;

    public APITestRun() {
    }

    public APITestRun(Long id, Integer number, LocalDateTime createTime, String displayName, Float executionRatio, Float successRatio, Long startedById, String startedByDisplayName, State state, Long userId, Long projectId, Long screenshotsFileId, Long logsFileId, Integer testCaseCount, Integer successfulTestCaseCount, Integer failedTestCaseCount, Integer totalDeviceCount, Integer finishedDeviceCount, Integer excludedDeviceCount, Integer errorsDeviceCount, Integer succeededDeviceCount, Integer runningDeviceCount, Integer warningDeviceCount, Integer waitingDeviceCount, Integer abortedDeviceCount, Integer timeoutedDeviceCount, Long frameworkId, String frameworkName, String testRunConfigurationContent) {
        super(id);
        this.number = number;
        this.createTime = TimeConverter.toDate(createTime);
        this.displayName = displayName;
        this.executionRatio = executionRatio;
        this.successRatio = successRatio;
        this.startedById = startedById;
        this.startedByDisplayName = startedByDisplayName;
        this.state = state;
        this.userId = userId;
        this.projectId = projectId;
        this.screenshotsFileId = screenshotsFileId;
        this.logsFileId = logsFileId;
        this.testCaseCount = testCaseCount;
        this.successfulTestCaseCount = successfulTestCaseCount;
        this.failedTestCaseCount = failedTestCaseCount;
        this.executedTestCaseCount = successfulTestCaseCount + failedTestCaseCount;
        this.totalDeviceCount = totalDeviceCount;
        this.finishedDeviceCount = finishedDeviceCount;
        this.excludedDeviceCount = excludedDeviceCount;
        this.errorsDeviceCount = errorsDeviceCount;
        this.succeededDeviceCount = succeededDeviceCount;
        this.runningDeviceCount = runningDeviceCount;
        this.warningDeviceCount = warningDeviceCount;
        this.waitingDeviceCount = waitingDeviceCount;
        this.abortedDeviceCount = abortedDeviceCount;
        this.timeoutedDeviceCount = timeoutedDeviceCount;
        this.frameworkId = frameworkId;
        this.frameworkName = frameworkName;
        this.mapConfig(testRunConfigurationContent);
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Float getExecutionRatio() {
        return this.executionRatio;
    }

    public void setExecutionRatio(Float executionRatio) {
        this.executionRatio = executionRatio;
    }

    public Float getSuccessRatio() {
        return this.successRatio;
    }

    public void setSuccessRatio(Float successRatio) {
        this.successRatio = successRatio;
    }

    public Long getStartedById() {
        return this.startedById;
    }

    public void setStartedById(Long startedById) {
        this.startedById = startedById;
    }

    public String getStartedByDisplayName() {
        return this.startedByDisplayName;
    }

    public void setStartedByDisplayName(String startedByDisplayName) {
        this.startedByDisplayName = startedByDisplayName;
    }

    public Long getScreenshotsFileId() {
        return this.screenshotsFileId;
    }

    public void setScreenshotsFileId(Long screenshotsFileId) {
        this.screenshotsFileId = screenshotsFileId;
    }

    public Long getLogsFileId() {
        return this.logsFileId;
    }

    public void setLogsFileId(Long logsFileId) {
        this.logsFileId = logsFileId;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    private String getTagsURI() {
        return APITestRun.createUri(this.selfURI, "/tags");
    }

    private String getDeviceSessionsURI() {
        return APITestRun.createUri(this.selfURI, "/device-sessions");
    }

    private String getRequestScreenshotsZipURI() {
        return APITestRun.createUri(this.selfURI, "/screenshots.zip");
    }

    private String getRequestLogsZipURI() {
        return APITestRun.createUri(this.selfURI, "/logs.zip");
    }

    private String getAbortURI() {
        return APITestRun.createUri(this.selfURI, "/abort");
    }

    private String getLogsZipURI() {
        return String.format("/files/%s", this.logsFileId);
    }

    private String getScreenshotsZipURI() {
        return String.format("/users/%s/files/%s", this.userId, this.screenshotsFileId);
    }

    public Integer getWaitingDeviceCount() {
        return this.waitingDeviceCount;
    }

    public void setWaitingDeviceCount(Integer waitingDeviceCount) {
        this.waitingDeviceCount = waitingDeviceCount;
    }

    public Integer getWarningDeviceCount() {
        return this.warningDeviceCount;
    }

    public void setWarningDeviceCount(Integer warningDeviceCount) {
        this.warningDeviceCount = warningDeviceCount;
    }

    public Integer getRunningDeviceCount() {
        return this.runningDeviceCount;
    }

    public void setRunningDeviceCount(Integer runningDeviceCount) {
        this.runningDeviceCount = runningDeviceCount;
    }

    public Integer getSucceededDeviceCount() {
        return this.succeededDeviceCount;
    }

    public void setSucceededDeviceCount(Integer succeededDeviceCount) {
        this.succeededDeviceCount = succeededDeviceCount;
    }

    public Integer getTestCaseCount() {
        return this.testCaseCount;
    }

    public void setTestCaseCount(Integer testCaseCount) {
        this.testCaseCount = testCaseCount;
    }

    public Integer getSuccessfulTestCaseCount() {
        return this.successfulTestCaseCount;
    }

    public void setSuccessfulTestCaseCount(Integer successfulTestCaseCount) {
        this.successfulTestCaseCount = successfulTestCaseCount;
    }

    public Integer getFailedTestCaseCount() {
        return this.failedTestCaseCount;
    }

    public void setFailedTestCaseCount(Integer failedTestCaseCount) {
        this.failedTestCaseCount = failedTestCaseCount;
    }

    public Integer getExecutedTestCaseCount() {
        return this.executedTestCaseCount;
    }

    public void setExecutedTestCaseCount(Integer executedTestCaseCount) {
        this.executedTestCaseCount = executedTestCaseCount;
    }

    public Integer getTotalDeviceCount() {
        return this.totalDeviceCount;
    }

    public void setTotalDeviceCount(Integer totalDeviceCount) {
        this.totalDeviceCount = totalDeviceCount;
    }

    public Integer getFinishedDeviceCount() {
        return this.finishedDeviceCount;
    }

    public void setFinishedDeviceCount(Integer finishedDeviceCount) {
        this.finishedDeviceCount = finishedDeviceCount;
    }

    public Integer getExcludedDeviceCount() {
        return this.excludedDeviceCount;
    }

    public void setExcludedDeviceCount(Integer excludedDeviceCount) {
        this.excludedDeviceCount = excludedDeviceCount;
    }

    public Integer getErrorsDeviceCount() {
        return this.errorsDeviceCount;
    }

    public void setErrorsDeviceCount(Integer errorsDeviceCount) {
        this.errorsDeviceCount = errorsDeviceCount;
    }

    public Integer getAbortedDeviceCount() {
        return this.abortedDeviceCount;
    }

    public void setAbortedDeviceCount(Integer abortedDeviceCount) {
        this.abortedDeviceCount = abortedDeviceCount;
    }

    public Integer getTimeoutedDeviceCount() {
        return this.timeoutedDeviceCount;
    }

    public void setTimeoutedDeviceCount(Integer timeoutedDeviceCount) {
        this.timeoutedDeviceCount = timeoutedDeviceCount;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getFrameworkId() {
        return this.frameworkId;
    }

    public void setFrameworkId(Long frameworkId) {
        this.frameworkId = frameworkId;
    }

    public String getFrameworkName() {
        return this.frameworkName;
    }

    public void setFrameworkName(String frameworkName) {
        this.frameworkName = frameworkName;
    }

    public void setConfig(APITestRunConfig config) {
        this.config = config;
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    public APITestRunConfig getConfig() {
        return this.config;
    }

    public APITag addTag(String name) throws APIException {
        return this.postResource(this.getTagsURI(), Collections.singletonMap("name", name), APITag.class);
    }

    @JsonIgnore
    public APIListResource<APITag> getTagsResource() throws APIException {
        return this.getListResource(this.getTagsURI(), APITag.class);
    }

    @JsonIgnore
    public APIListResource<APITag> getTagsResource(Context<APITag> context) throws APIException {
        return this.getListResource(this.getTagsURI(), context);
    }

    @JsonIgnore
    public APIListResource<APIDeviceSession> getDeviceSessionsResource() throws APIException {
        return this.getListResource(this.getDeviceSessionsURI(), APIDeviceSession.class);
    }

    @JsonIgnore
    public APIListResource<APIDeviceSession> getDeviceSessionsResource(Context<APIDeviceSession> context) throws APIException {
        return this.getListResource(this.getDeviceSessionsURI(), context);
    }

    @JsonIgnore
    public void requestScreenshotsZip() throws APIException {
        APIUserFile result = this.postResource(this.getRequestScreenshotsZipURI(), null, APIUserFile.class);
        this.screenshotsFileId = result.getId();
    }

    @JsonIgnore
    public void requestLogsZip() throws APIException {
        APIUserFile result = this.postResource(this.getRequestLogsZipURI(), null, APIUserFile.class);
        this.logsFileId = result.getId();
    }

    @JsonIgnore
    public APIUserFile getScreenshotsZip() throws APIException {
        return super.getResource(this.getScreenshotsZipURI(), APIUserFile.class).getEntity();
    }

    @JsonIgnore
    public APIUserFile getLogsZip() throws APIException {
        return super.getResource(this.getLogsZipURI(), APIUserFile.class).getEntity();
    }

    public void update() throws APIException {
        APITestRun testRun = this.postResource(this.selfURI, Collections.singletonMap("displayName", this.displayName), APITestRun.class);
        this.clone(testRun);
    }

    public void abort() throws APIException {
        this.postResource(this.getAbortURI(), null, null);
    }

    @JsonIgnore
    private void mapConfig(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        try {
            APITestRunConfig config = (APITestRunConfig)OBJECT_MAPPER.readValue(content, APITestRunConfig.class);
            this.setConfig(config);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APITestRun apiTestRun = (APITestRun)from;
        this.cloneBase(from);
        this.config = apiTestRun.config;
        this.createTime = apiTestRun.createTime;
        this.displayName = apiTestRun.displayName;
        this.executionRatio = apiTestRun.executionRatio;
        this.number = apiTestRun.number;
        this.startedById = apiTestRun.startedById;
        this.startedByDisplayName = apiTestRun.startedByDisplayName;
        this.state = apiTestRun.state;
        this.successRatio = apiTestRun.successRatio;
        this.userId = apiTestRun.userId;
        this.projectId = apiTestRun.projectId;
        this.screenshotsFileId = apiTestRun.screenshotsFileId;
        this.logsFileId = apiTestRun.logsFileId;
        this.testCaseCount = apiTestRun.testCaseCount;
        this.successfulTestCaseCount = apiTestRun.successfulTestCaseCount;
        this.failedTestCaseCount = apiTestRun.failedTestCaseCount;
        this.totalDeviceCount = apiTestRun.totalDeviceCount;
        this.finishedDeviceCount = apiTestRun.finishedDeviceCount;
        this.excludedDeviceCount = apiTestRun.excludedDeviceCount;
        this.errorsDeviceCount = apiTestRun.errorsDeviceCount;
        this.warningDeviceCount = apiTestRun.warningDeviceCount;
        this.runningDeviceCount = apiTestRun.runningDeviceCount;
        this.succeededDeviceCount = apiTestRun.succeededDeviceCount;
        this.waitingDeviceCount = apiTestRun.waitingDeviceCount;
        this.abortedDeviceCount = apiTestRun.abortedDeviceCount;
        this.timeoutedDeviceCount = apiTestRun.timeoutedDeviceCount;
        this.frameworkId = apiTestRun.frameworkId;
        this.frameworkName = apiTestRun.frameworkName;
    }

    @XmlType(namespace="APITestRun", name="APITestRunState")
    public static enum State {
        WAITING,
        RUNNING,
        FINISHED;

    }
}

