/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.model.APIUserFileProperty;
import com.testdroid.api.model.APIUserFileTag;
import com.testdroid.api.util.TimeConverter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
public class APIUserFile
extends APIEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date createTime;
    private APIUserFileProperty[] fileProperties;
    private State state;
    private String name;
    private Long size;
    private URL directUrl;
    private URL iconDirectUrl;
    private String mimetype;
    private Direction direction;
    private InputType inputType;
    private boolean duplicate;
    private String userEmail;
    private Long userId;
    private boolean isShared;
    private transient String storage;
    private transient String uri;
    private transient String iconUri;

    public APIUserFile() {
    }

    public APIUserFile(Long id, String name, LocalDateTime createTime, Long size, State state, String storage, String uri, String iconUri, String mimetype, Direction direction, InputType inputType, Long userId, String userEmail, boolean isShared) {
        super(id);
        this.name = name;
        this.createTime = TimeConverter.toDate(createTime);
        this.size = size;
        this.state = state;
        this.storage = storage;
        this.uri = uri;
        this.iconUri = iconUri;
        this.mimetype = mimetype;
        this.direction = direction;
        this.inputType = inputType;
        this.userId = userId;
        this.userEmail = userEmail;
        this.isShared = isShared;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public APIUserFileProperty[] getFileProperties() {
        return this.fileProperties;
    }

    public void setFileProperties(APIUserFileProperty[] fileProperties) {
        this.fileProperties = fileProperties;
    }

    private String getFileURI() {
        return APIUserFile.createUri(this.selfURI, "/file");
    }

    private String getIconURI() {
        return APIUserFile.createUri(this.selfURI, "/icon");
    }

    private String getFileTagsURI() {
        return APIUserFile.createUri(this.selfURI, "/tags");
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public URL getDirectUrl() {
        return this.directUrl;
    }

    public void setDirectUrl(URL directUrl) {
        this.directUrl = directUrl;
    }

    @JsonIgnore
    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    @JsonIgnore
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public URL getIconDirectUrl() {
        return this.iconDirectUrl;
    }

    public void setIconDirectUrl(URL iconDirectUrl) {
        this.iconDirectUrl = iconDirectUrl;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    @JsonIgnore
    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    @JsonIgnore
    public InputStream getIcon() throws APIException {
        return this.getFile(this.getIconURI());
    }

    @JsonIgnore
    public InputStream getFile() throws APIException {
        return this.getFile(this.getFileURI());
    }

    @JsonIgnore
    public APIListResource<APIUserFileTag> getTagsResource() throws APIException {
        return this.getListResource(this.getFileTagsURI(), APIUserFileTag.class);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUserFile apiUserFile = (APIUserFile)from;
        this.cloneBase(from);
        this.name = apiUserFile.name;
        this.createTime = apiUserFile.createTime;
        this.size = apiUserFile.size;
        this.fileProperties = apiUserFile.fileProperties;
        this.state = apiUserFile.state;
        this.directUrl = apiUserFile.directUrl;
        this.iconDirectUrl = apiUserFile.iconDirectUrl;
        this.storage = apiUserFile.storage;
        this.uri = apiUserFile.uri;
        this.iconUri = apiUserFile.iconUri;
        this.direction = apiUserFile.direction;
        this.mimetype = apiUserFile.mimetype;
        this.inputType = apiUserFile.inputType;
        this.userId = apiUserFile.userId;
        this.userEmail = apiUserFile.userEmail;
        this.isShared = apiUserFile.isShared;
    }

    @XmlType(namespace="APIUserFile", name="APIUserFileState")
    public static enum State {
        PREPARING,
        READY;

    }

    @XmlType(namespace="APIUserFile")
    public static enum Direction {
        INPUT,
        OUTPUT;

    }

    @XmlType(namespace="APIUserFile")
    public static enum InputType {
        APPLICATION,
        TEST,
        DATA;

    }
}

