/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIResource;
import com.testdroid.api.dto.Context;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public abstract class APIEntity {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final XmlMapper XML_MAPPER = new XmlMapper();
    protected APIClient client;
    protected Long id;
    protected String selfURI;
    @JsonIgnore
    protected Long parentId;

    public APIEntity() {
    }

    public APIEntity(Long id) {
        this.id = id;
    }

    @JsonIgnore
    protected static String createUri(String preUri, String postUri) {
        if (preUri.contains("?")) {
            String[] parts = preUri.split("\\?");
            return String.format("%s%s", parts[0], postUri);
        }
        return String.format("%s%s", preUri, postUri);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSelfURI() {
        return this.selfURI;
    }

    public void setSelfURI(String selfURI) {
        this.selfURI = selfURI;
    }

    public Long getParentId() {
        return this.parentId;
    }

    @JsonIgnore
    protected <T extends APIEntity> APIResource<T> getResource(String uri, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return new APIResource<T>(this.client, uri, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return new APIListResource<T>(this.client, uri, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri, Context<T> context) throws APIException {
        this.checkClient(this.client);
        return new APIListResource<T>(this.client, uri, context);
    }

    @JsonIgnore
    protected <T extends APIEntity> T postResource(String uri, Object body, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return this.client.post(uri, body, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> T postFile(String uri, File file, Map<String, String> fileExtraParams, String contentType, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return this.client.postFile(uri, contentType, file, fileExtraParams, type);
    }

    @JsonIgnore
    protected void deleteResource(String uri) throws APIException {
        this.checkClient(this.client);
        this.client.delete(uri);
    }

    @JsonIgnore
    protected InputStream getFile(String uri) throws APIException {
        this.checkClient(this.client);
        return this.client.get(uri);
    }

    @JsonIgnore
    public void refresh() throws APIException {
        this.checkClient(this.client);
        this.clone((APIEntity)this.client.get(this.selfURI, this.getClass()));
    }

    @JsonIgnore
    private void checkClient(APIClient client) throws APIException {
        if (client == null) {
            throw new APIException("Missing API client");
        }
    }

    @JsonIgnore
    public String toJson() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this);
    }

    @JsonIgnore
    protected abstract <T extends APIEntity> void clone(T var1);

    @JsonIgnore
    protected <T extends APIEntity> void cloneBase(T from) {
        this.id = from.id;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        OBJECT_MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        XML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        XML_MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        XML_MAPPER.registerModule((Module)new JavaTimeModule());
        XML_MAPPER.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        XML_MAPPER.configure(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL, true);
    }
}

