/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.testdroid.api.AbstractAPIClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIKeyClient
extends AbstractAPIClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIKeyClient.class);
    private String apiKey;

    public APIKeyClient(String cloudURL, String apiKey) {
        this(cloudURL, apiKey, false);
    }

    public APIKeyClient(String cloudURL, String apiKey, boolean skipCheckCertificate) {
        NetHttpTransport.Builder netHttpBuilder;
        if (skipCheckCertificate) {
            try {
                netHttpBuilder = new NetHttpTransport.Builder().doNotValidateCertificate();
            }
            catch (GeneralSecurityException ex) {
                LOGGER.warn("Cannot set not-validating certificate. Certificate will be validating.", (Throwable)ex);
                netHttpBuilder = new NetHttpTransport.Builder();
            }
        } else {
            netHttpBuilder = new NetHttpTransport.Builder();
        }
        this.httpTransport = netHttpBuilder.build();
        this.initializeDefaultAPIClient(cloudURL, apiKey);
    }

    public APIKeyClient(String cloudURL, String username, HttpHost proxy, boolean skipCheckCertificate) {
        ApacheHttpTransport.Builder apacheBuilder;
        if (skipCheckCertificate) {
            try {
                apacheBuilder = new ApacheHttpTransport.Builder().setProxy(proxy).doNotValidateCertificate();
            }
            catch (GeneralSecurityException ex) {
                LOGGER.warn("Cannot set not-validating certificate. Certificate will be validating.", (Throwable)ex);
                apacheBuilder = new ApacheHttpTransport.Builder().setProxy(proxy);
            }
        } else {
            apacheBuilder = new ApacheHttpTransport.Builder().setProxy(proxy);
        }
        this.httpTransport = apacheBuilder.build();
        this.initializeDefaultAPIClient(cloudURL, username);
    }

    public APIKeyClient(String cloudURL, String apiKey, HttpHost proxy, String proxyUser, String proxyPassword, boolean skipCheckCertificate) {
        this(cloudURL, apiKey, proxy, skipCheckCertificate);
        DefaultHttpClient apacheClient = (DefaultHttpClient)((ApacheHttpTransport)this.httpTransport).getHttpClient();
        apacheClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        apacheClient.getCredentialsProvider().setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme(ChallengeState.PROXY);
        authCache.put(proxy, (AuthScheme)basicAuth);
        apacheClient.addRequestInterceptor((arg_0, arg_1) -> APIKeyClient.lambda$new$0((AuthCache)authCache, arg_0, arg_1), 0);
    }

    private void initializeDefaultAPIClient(String cloudURL, String apiKey) {
        this.apiURL = StringUtils.removeEnd((String)cloudURL, (String)"/") + "/api/v2";
        this.apiKey = apiKey;
    }

    @Override
    protected HttpHeaders getHttpHeaders() {
        return new HttpHeaders().setAccept("application/json").setBasicAuthentication(this.apiKey, "");
    }

    private static /* synthetic */ void lambda$new$0(AuthCache authCache, HttpRequest hr, HttpContext hc) throws HttpException, IOException {
        hc.setAttribute("http.auth.auth-cache", (Object)authCache);
    }
}

