/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.UrlEncodedContent;
import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIExceptionMessage;
import com.testdroid.api.APIList;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.dto.Operand;
import com.testdroid.api.filter.FilterEntry;
import com.testdroid.api.http.MultipartFormDataContent;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceProperty;
import com.testdroid.api.model.APILabelGroup;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.util.TypeReferenceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;

public abstract class AbstractAPIClient
implements APIClient {
    protected static final String API_URI = "/api/v2";
    protected static final String ACCEPT_HEADER = "application/json";
    protected static final String DEVICES_URI = "/devices";
    protected static final String LABEL_GROUPS_URI = "/label-groups";
    private static final String FAILED_TO_EXECUTE_API_CALL_WITH_REASON = "Failed to execute API call: %s. Reason: %s";
    protected int clientConnectTimeout = 20000;
    protected int clientRequestTimeout = 60000;
    protected HttpTransport httpTransport;
    protected String apiURL;
    private static final List<Integer> POSSIBLE_DELETE_STATUSES = Arrays.asList(200, 202, 204);
    private static final List<Integer> POSSIBLE_GET_STATUSES = Arrays.asList(200, 202, 201, 204);

    protected HttpRequestFactory getRequestFactory() throws APIException {
        return this.httpTransport.createRequestFactory();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.clientConnectTimeout = timeout;
    }

    @Override
    public void setRequestTimeout(int timeout) {
        this.clientRequestTimeout = timeout;
    }

    @Override
    public <T extends APIEntity> T get(String uri, Class<T> type) throws APIException {
        return this.getOnce(uri, null, TypeReferenceFactory.getTypeRef(type));
    }

    @Override
    public InputStream get(String uri) throws APIException {
        return this.getStream(uri);
    }

    @Override
    public <T extends APIEntity> APIList<T> get(String uri, Context<T> context) throws APIException {
        return this.getOnce(uri, context, TypeReferenceFactory.getListTypeRef(context.getType()));
    }

    protected abstract HttpHeaders getHttpHeaders();

    protected <T extends APIEntity> T getOnce(String uri, Context<?> context, TypeReference<T> type) throws APIException {
        HttpResponse response = this.getHttpResponse(uri, context);
        try {
            APIEntity result = (APIEntity)this.fromJson(response.getContent(), type);
            result.client = this;
            if (result.selfURI == null) {
                result.selfURI = uri;
            }
            APIEntity aPIEntity = result;
            return (T)aPIEntity;
        }
        catch (IOException ex) {
            throw new APIException(String.format(FAILED_TO_EXECUTE_API_CALL_WITH_REASON, uri, ex.getMessage()), ex);
        }
        finally {
            this.disconnectQuietly(response);
        }
    }

    protected InputStream getStream(String uri) throws APIException {
        try {
            return this.getHttpResponse(uri, null).getContent();
        }
        catch (IOException ex) {
            throw new APIException(String.format(FAILED_TO_EXECUTE_API_CALL_WITH_REASON, uri, ex.getMessage()), ex);
        }
    }

    @Override
    public HttpResponse getHttpResponse(String uri, Context<?> context) throws APIException {
        HttpRequestFactory factory = this.getRequestFactory();
        uri = uri.replaceAll("\\+", "%2B");
        try {
            HttpRequest request = factory.buildGetRequest(new GenericUrl(this.buildUrl(this.apiURL + uri, context)));
            request.setHeaders(this.getHttpHeaders());
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            HttpResponse response = request.execute();
            if (!POSSIBLE_GET_STATUSES.contains(response.getStatusCode())) {
                throw new APIException(response.getStatusCode(), String.format("Failed to execute api call: %s", uri));
            }
            return response;
        }
        catch (HttpResponseException ex) {
            throw this.getAPIException(ex);
        }
        catch (IOException ex) {
            throw new APIException(String.format(FAILED_TO_EXECUTE_API_CALL_WITH_REASON, uri, ex.getMessage()), ex);
        }
    }

    @Override
    public <T extends APIEntity> T post(String uri, Object body, Class<T> type) throws APIException {
        return this.postOnce(uri, body, Collections.emptyMap(), null, TypeReferenceFactory.getTypeRef(type));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T extends APIEntity> T postOnce(String uri, Object body, Map<String, String> fileExtraParams, String contentType, TypeReference<T> type) throws APIException {
        T t;
        if (contentType == null) {
            contentType = ACCEPT_HEADER;
        }
        HttpRequestFactory factory = this.getRequestFactory();
        HttpResponse response = null;
        String resourceUrl = this.apiURL + uri;
        try {
            Object content;
            HttpHeaders headers = this.getHttpHeaders();
            if (body instanceof File) {
                MultipartFormDataContent multipartContent = new MultipartFormDataContent();
                FileContent fileContent = new FileContent(contentType, (File)body);
                MultipartFormDataContent.Part filePart = new MultipartFormDataContent.Part("file", (HttpContent)fileContent);
                multipartContent.addPart(filePart);
                for (String name : fileExtraParams.keySet()) {
                    MultipartFormDataContent.Part part = new MultipartFormDataContent.Part(name, (HttpContent)new ByteArrayContent(null, fileExtraParams.get(name).getBytes()));
                    part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"%s\"", name)));
                    multipartContent.addPart(part);
                }
                content = multipartContent;
            } else if (body instanceof InputStream) {
                headers.setContentType(contentType);
                content = new InputStreamContent(contentType, (InputStream)body);
            } else {
                content = body instanceof APIEntity ? new InputStreamContent(contentType, IOUtils.toInputStream((String)((APIEntity)body).toJson(), (Charset)StandardCharsets.UTF_8)) : (body instanceof HttpContent ? (HttpContent)body : (body instanceof Map ? new UrlEncodedContent(this.fixMapParameters((Map)body)) : (body == null ? null : new ByteArrayContent("text/plain", body.toString().getBytes()))));
            }
            HttpRequest request = factory.buildPostRequest(new GenericUrl(resourceUrl), content);
            request.setHeaders(headers);
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            response = request.execute();
            if (response == null) {
                throw new APIException("No response from API");
            }
            if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw new APIException(response.getStatusCode(), "Failed to post resource: " + response.getStatusMessage());
            }
            if (type != null) {
                APIEntity result = (APIEntity)this.fromJson(response.getContent(), type);
                result.client = this;
                if (result.selfURI == null) {
                    result.selfURI = uri;
                    if (response.getStatusCode() == 201 && result.getId() != null) {
                        result.selfURI = result.selfURI + String.format("/%s", result.getId());
                    }
                }
                APIEntity aPIEntity = result;
                this.disconnectQuietly(response);
                return (T)aPIEntity;
            }
        }
        catch (HttpResponseException ex) {
            try {
                throw this.getAPIException(ex);
                catch (IOException ex2) {
                    throw new APIException(String.format(FAILED_TO_EXECUTE_API_CALL_WITH_REASON, uri, ex2.getMessage()), ex2);
                }
            }
            catch (Throwable throwable) {
                this.disconnectQuietly(response);
                throw throwable;
            }
        }
        {
            t = null;
            this.disconnectQuietly(response);
        }
        return t;
    }

    @Override
    public <T extends APIEntity> T postFile(String uri, String contentType, File file, Map<String, String> fileExtraParams, Class<T> type) throws APIException {
        return this.postOnce(uri, file, fileExtraParams, contentType, TypeReferenceFactory.getTypeRef(type));
    }

    @Override
    public void delete(String uri) throws APIException {
        this.deleteOnce(uri);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteOnce(String uri) throws APIException {
        HttpRequestFactory factory = this.getRequestFactory();
        HttpResponse response = null;
        try {
            HttpRequest request = factory.buildDeleteRequest(new GenericUrl(this.apiURL + uri));
            request.setHeaders(this.getHttpHeaders());
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            response = request.execute();
            if (response == null) {
                throw new APIException("No response from API");
            }
            if (!POSSIBLE_DELETE_STATUSES.contains(response.getStatusCode())) {
                throw new APIException(response.getStatusCode(), "Failed to delete resource: " + response.getStatusMessage());
            }
            this.disconnectQuietly(response);
            return;
        }
        catch (HttpResponseException ex) {
            try {
                throw this.getAPIException(ex);
                catch (IOException ex2) {
                    throw new APIException(String.format(FAILED_TO_EXECUTE_API_CALL_WITH_REASON, uri, ex2.getMessage()), ex2);
                }
            }
            catch (Throwable throwable) {
                this.disconnectQuietly(response);
                throw throwable;
            }
        }
    }

    @Override
    public APIUser me() throws APIException {
        return this.get("/me", APIUser.class);
    }

    @Override
    public APIListResource<APIDevice> getDevices() {
        return new APIListResource<APIDevice>((APIClient)this, DEVICES_URI, APIDevice.class);
    }

    @Override
    public APIListResource<APIDevice> getDevices(Context<APIDevice> context) {
        return new APIListResource<APIDevice>((APIClient)this, DEVICES_URI, context);
    }

    @Override
    public APIListResource<APILabelGroup> getLabelGroups() {
        return new APIListResource<APILabelGroup>((APIClient)this, LABEL_GROUPS_URI, APILabelGroup.class);
    }

    @Override
    public APIListResource<APILabelGroup> getLabelGroups(Context<APILabelGroup> context) {
        return new APIListResource<APILabelGroup>((APIClient)this, LABEL_GROUPS_URI, context);
    }

    @Override
    public Optional<APIDeviceProperty> findDevicePropertyInLabelGroup(String groupName, String labelName) throws APIException {
        Optional<APIDeviceProperty> result = Optional.empty();
        Context<APILabelGroup> ctx = new Context<APILabelGroup>(APILabelGroup.class);
        ctx.addFilter(new FilterEntry("name", Operand.EQ, (Object)groupName));
        List<APILabelGroup> labelGroups = this.getLabelGroups(ctx).getEntity().getData();
        if (CollectionUtils.isNotEmpty(labelGroups)) {
            Context<APIDeviceProperty> lCtx = new Context<APIDeviceProperty>(APIDeviceProperty.class);
            lCtx.addFilter(new FilterEntry("name", Operand.EQ, (Object)labelName));
            result = labelGroups.get(0).getDevicePropertiesResource(lCtx).getEntity().getData().stream().findFirst();
        }
        return result;
    }

    protected <T> T fromJson(InputStream inputStream, TypeReference<T> type) throws APIException {
        try {
            return (T)APIEntity.OBJECT_MAPPER.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new APIException(String.format("Failed to parse response as %s: %s", type.getType().getTypeName(), this.getAPIResponceContent(inputStream, type)));
        }
    }

    private String getAPIResponceContent(InputStream inputStream, TypeReference<?> type) throws APIException {
        try {
            return IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new APIException(String.format("Failed to parse response as %s", type.getType().getTypeName()));
        }
    }

    protected <T> T fromJson(String content, TypeReference<T> type) throws APIException {
        try {
            return (T)APIEntity.OBJECT_MAPPER.readValue(content, type);
        }
        catch (IOException e) {
            throw new APIException(String.format("Failed to parse response as %s: %s", type.getType().getTypeName(), content));
        }
    }

    protected <T extends APIEntity> String buildUrl(String url, Context<T> context) throws APIException {
        try {
            URIBuilder builder = new URIBuilder(url);
            if (context != null) {
                for (Map.Entry entry : context.build().asMap().entrySet()) {
                    for (Object value : (Collection)entry.getValue()) {
                        builder.addParameter((String)entry.getKey(), value == null ? "" : value.toString());
                    }
                }
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new APIException(String.format("Bad URL: %s", e.getMessage()));
        }
    }

    protected Map<String, Object> fixMapParameters(Map<String, Object> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> p.getValue() == null ? "" : (p.getValue() instanceof Enum ? p.getValue().toString() : p.getValue())));
    }

    protected APIException getAPIException(HttpResponseException ex) {
        if (ex.getContent() == null) {
            return this.getNoContentAPIException(ex);
        }
        try {
            APIExceptionMessage exceptionMessage = this.fromJson(ex.getContent(), TypeReferenceFactory.getTypeRef(APIExceptionMessage.class));
            return new APIException(ex.getStatusCode(), exceptionMessage.getMessage(), ex);
        }
        catch (APIException e) {
            return new APIException(ex.getStatusCode(), ex.getMessage());
        }
    }

    private APIException getNoContentAPIException(HttpResponseException ex) {
        String message;
        switch (ex.getStatusCode()) {
            case 401: {
                message = "Unauthenticated access";
                break;
            }
            case 403: {
                message = "Unauthorized access";
                break;
            }
            default: {
                message = String.format("Unknown exception: %s - %s", ex.getStatusCode(), ex.getStatusMessage());
            }
        }
        return new APIException(ex.getStatusCode(), message);
    }

    protected void disconnectQuietly(HttpResponse httpResponse) {
        if (httpResponse != null) {
            try {
                httpResponse.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

