/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.dto;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APISort;
import com.testdroid.api.dto.Operand;
import com.testdroid.api.filter.FilterEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class Context<T extends APIEntity> {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    public static final String FILTER_REQUEST_PARAM = "filter";
    public static final String SEARCH_REQUEST_PARAM = "search";
    public static final String FILTER_DELIMITER = ";";
    public static final String GROUP_REQUEST_PARAM = "group";
    public static final String LIMIT_REQUEST_PARAM = "limit";
    public static final String SORT_REQUEST_PARAM = "sort";
    public static final String OFFSET_REQUEST_PARAM = "offset";
    private int limit = 20;
    private int offset = 0;
    private String search;
    private APISort sort;
    private List<String> groups = new ArrayList<String>();
    private List<FilterEntry> filters = new ArrayList<FilterEntry>();
    private final Class<T> type;
    private Boolean cacheable = Boolean.FALSE;
    private MultiValuedMap<String, Object> extraParams = new HashSetValuedHashMap();
    private Long count;

    public Context(Class<T> type) {
        this.type = type;
    }

    public Context(Class<T> type, int offset, int limit, String search, String sort) {
        this.offset = offset;
        this.limit = limit;
        this.search = search;
        this.type = type;
        this.sort = APISort.deserialize(sort);
    }

    public Context(Class<T> type, int offset, int limit, String search, String sort, List<FilterEntry> filters, List<String> groups) {
        this.offset = offset;
        this.limit = limit;
        this.search = search;
        this.type = type;
        this.sort = APISort.deserialize(sort);
        this.filters = filters;
        this.groups = groups;
    }

    public int getOffset() {
        return this.offset;
    }

    public Context<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Context<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public String getSearch() {
        return this.search;
    }

    public Context<T> setSearch(String search) {
        this.search = search;
        return this;
    }

    public APISort getSort() {
        return this.sort;
    }

    public Optional<APISort.SortItem> findSort(String field) {
        return this.sort.getSorts().stream().filter(s -> Objects.equals(s.getColumn(), field)).findAny();
    }

    public Context<T> setSort(APISort sort) {
        this.sort = sort;
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public List<FilterEntry> getFilters() {
        return this.filters;
    }

    public Optional<FilterEntry> findFilter(String field, Operand operand) {
        return this.filters.stream().filter(f -> this.keyAndOperandEqual((FilterEntry)f, field, operand)).findAny();
    }

    public Context<T> setFilters(List<FilterEntry> filters) {
        this.filters = filters;
        return this;
    }

    public Context<T> addFilter(FilterEntry filterEntry) {
        this.filters.add(filterEntry);
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public Context<T> setCacheable(Boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public MultiValuedMap<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(MultiValuedMap<String, Object> extraParams) {
        this.extraParams = extraParams;
    }

    public Context<T> setCount(Long count) {
        this.count = count;
        return this;
    }

    public Optional<Integer> computeMaxResult() {
        Optional<Integer> maxResult = Optional.empty();
        if (this.limit != 0 && this.limit != Integer.MAX_VALUE) {
            maxResult = Objects.nonNull(this.count) && (long)(this.offset + this.limit) > this.count ? Optional.of(this.count.intValue() % this.limit) : Optional.of(this.limit);
        }
        return maxResult;
    }

    public MultiValuedMap<String, Object> build() {
        HashSetValuedHashMap map = new HashSetValuedHashMap();
        map.put((Object)LIMIT_REQUEST_PARAM, (Object)this.limit);
        map.put((Object)OFFSET_REQUEST_PARAM, (Object)this.offset);
        map.put((Object)SEARCH_REQUEST_PARAM, (Object)this.search);
        map.put((Object)SORT_REQUEST_PARAM, this.sort != null ? this.sort.serialize() : null);
        map.put((Object)FILTER_REQUEST_PARAM, (Object)this.filters.stream().map(FilterEntry::toString).collect(Collectors.joining(FILTER_DELIMITER)));
        map.put((Object)GROUP_REQUEST_PARAM, this.groups);
        map.putAll(this.extraParams);
        return map;
    }

    public <R extends T> Context<R> as(Class<R> clazz) {
        return new Context<R>(clazz, this.offset, this.limit, this.search, this.sort.serialize(), this.filters, this.groups);
    }

    private Boolean keyAndOperandEqual(FilterEntry fe, String field, Operand operand) {
        return Objects.equals(fe.getField(), field) && Objects.equals((Object)fe.getOperand(), (Object)operand);
    }
}

