/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIService;
import com.testdroid.api.model.enums.APIPaymentMethod;
import com.testdroid.api.model.enums.Unit;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.annotation.XmlType;

public class APIAccountService
extends APIEntity {
    private Long accountId;
    private Long activatedById;
    private String activatedByName;
    private boolean active;
    private boolean autoRenew;
    private String braintreeId;
    private Date createTime;
    private Long deactivatedById;
    private String deactivatedByName;
    private Date endTime;
    private boolean finished;
    private Date lastPaymentTime;
    private APIPaymentMethod paymentMethod;
    private Integer price;
    private Integer serviceCount;
    private Long serviceId;
    private String serviceName;
    private Date startTime;
    private Unit unit;
    private Integer unitCount;
    private String userEmail;
    private Long userId;
    private Integer vatRate;
    private DeactivateReason deactivateReason;
    private APIService.ChargeType chargeType;
    private String subscriptionManagementURL;

    public APIAccountService() {
    }

    public APIAccountService(Long accountId, Long activatedById, String activatedByName, boolean active, boolean autoRenew, String braintreeId, LocalDateTime createTime, Long deactivatedById, String deactivatedByName, LocalDateTime endTime, boolean finished, Long id, LocalDateTime lastPaymentTime, APIPaymentMethod paymentMethod, Integer price, Long serviceId, LocalDateTime startTime, String userEmail, Long userId, Integer vatRate, Unit unit, Integer unitCount, Integer serviceCount, String serviceName, DeactivateReason deactivateReason, APIService.ChargeType chargeType) {
        super(id);
        this.accountId = accountId;
        this.activatedById = activatedById;
        this.activatedByName = activatedByName;
        this.active = active;
        this.autoRenew = autoRenew;
        this.braintreeId = braintreeId;
        this.createTime = TimeConverter.toDate(createTime);
        this.deactivatedById = deactivatedById;
        this.deactivatedByName = deactivatedByName;
        this.endTime = TimeConverter.toDate(endTime);
        this.finished = finished;
        this.lastPaymentTime = TimeConverter.toDate(lastPaymentTime);
        this.paymentMethod = paymentMethod;
        this.price = price;
        this.serviceId = serviceId;
        this.startTime = TimeConverter.toDate(startTime);
        this.userEmail = userEmail;
        this.userId = userId;
        this.vatRate = vatRate;
        this.unit = unit;
        this.unitCount = unitCount;
        this.serviceCount = serviceCount;
        this.serviceName = serviceName;
        this.deactivateReason = deactivateReason;
        this.chargeType = chargeType;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getActivatedById() {
        return this.activatedById;
    }

    public void setActivatedById(Long activatedById) {
        this.activatedById = activatedById;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getDeactivatedById() {
        return this.deactivatedById;
    }

    public void setDeactivatedById(Long deactivatedById) {
        this.deactivatedById = deactivatedById;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getLastPaymentTime() {
        return this.lastPaymentTime;
    }

    public void setLastPaymentTime(Date lastPaymentTime) {
        this.lastPaymentTime = lastPaymentTime;
    }

    public APIPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(APIPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Integer getVatRate() {
        return this.vatRate;
    }

    public void setVatRate(Integer vatRate) {
        this.vatRate = vatRate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Integer getTotal() {
        return this.price * (100 + this.vatRate) / 100;
    }

    public Integer getPrice() {
        return this.price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public String getBraintreeId() {
        return this.braintreeId;
    }

    public void setBraintreeId(String braintreeId) {
        this.braintreeId = braintreeId;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Integer getUnitCount() {
        return this.unitCount;
    }

    public void setUnitCount(Integer unitCount) {
        this.unitCount = unitCount;
    }

    public Integer getServiceCount() {
        return this.serviceCount;
    }

    public void setServiceCount(Integer serviceCount) {
        this.serviceCount = serviceCount;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getActivatedByName() {
        return this.activatedByName;
    }

    public void setActivatedByName(String activatedByName) {
        this.activatedByName = activatedByName;
    }

    public String getDeactivatedByName() {
        return this.deactivatedByName;
    }

    public void setDeactivatedByName(String deactivatedByName) {
        this.deactivatedByName = deactivatedByName;
    }

    public DeactivateReason getDeactivateReason() {
        return this.deactivateReason;
    }

    public void setDeactivateReason(DeactivateReason deactivateReason) {
        this.deactivateReason = deactivateReason;
    }

    public APIService.ChargeType getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(APIService.ChargeType chargeType) {
        this.chargeType = chargeType;
    }

    public void setSubscriptionManagementURL(String subscriptionManagementURL) {
        this.subscriptionManagementURL = subscriptionManagementURL;
    }

    public String getSubscriptionManagementURL() {
        return this.subscriptionManagementURL;
    }

    @JsonIgnore
    public Integer getPayUnitCount() {
        return this.autoRenew ? this.unitCount : this.unitCount * this.serviceCount;
    }

    @JsonIgnore
    public String getVatPriceString() {
        float vatPrice = this.getPrice() * this.getVatRate() / 100;
        return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(vatPrice / 100.0f));
    }

    @JsonIgnore
    public String getNetPriceString() {
        return String.format(Locale.ENGLISH, "%.2f", Float.valueOf((float)this.getPrice().intValue() / 100.0f));
    }

    @JsonIgnore
    public String getTotalPriceString() {
        float totalPrice = this.getPrice() * (100 + this.getVatRate()) / 100;
        return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(totalPrice / 100.0f));
    }

    @Override
    @JsonIgnore
    public <T extends APIEntity> void clone(T from) {
        APIAccountService accountService = (APIAccountService)from;
        this.cloneBase(from);
        this.accountId = accountService.accountId;
        this.active = accountService.active;
        this.finished = accountService.finished;
        this.autoRenew = accountService.autoRenew;
        this.price = accountService.price;
        this.activatedById = accountService.activatedById;
        this.activatedByName = accountService.activatedByName;
        this.createTime = accountService.createTime;
        this.deactivatedById = accountService.deactivatedById;
        this.deactivatedByName = accountService.deactivatedByName;
        this.endTime = accountService.endTime;
        this.lastPaymentTime = accountService.lastPaymentTime;
        this.paymentMethod = accountService.paymentMethod;
        this.serviceId = accountService.serviceId;
        this.startTime = accountService.startTime;
        this.vatRate = accountService.vatRate;
        this.unit = accountService.unit;
        this.unitCount = accountService.unitCount;
        this.serviceCount = accountService.serviceCount;
        this.serviceName = accountService.serviceName;
        this.userId = accountService.userId;
        this.braintreeId = accountService.braintreeId;
        this.deactivateReason = accountService.deactivateReason;
        this.chargeType = accountService.chargeType;
        this.subscriptionManagementURL = accountService.subscriptionManagementURL;
    }

    public boolean isActiveAt(Date date) {
        if (date == null) {
            return false;
        }
        if (this.startTime != null && (this.startTime.equals(date) || this.startTime.before(date))) {
            return this.endTime == null || this.endTime.after(date) || this.endTime.equals(date);
        }
        return false;
    }

    @XmlType(namespace="APIAccountService")
    public static enum DeactivateReason {
        INITIAL_FAILURE,
        SCA_FAILURE,
        CHARGE_FAILURE,
        CANCEL,
        SUSPENDED,
        ANOTHER_PURCHASE;

    }
}

