/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIList;
import com.testdroid.api.model.APIAdminDevice;
import com.testdroid.api.util.TimeConverter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class APICluster
extends APIEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private APIList<APIAdminDevice> devices;
    private Boolean enabled = true;
    private String name;
    private State state = State.ONLINE;
    private Date stateChangeTime = new Date();
    private Date stateTime = new Date();
    private String url;
    private String jenkinsUrl;
    private String pluginVersion;
    private Type type = Type.BARE_METAL;
    private String ipAddress;
    private String region;
    private String location;

    public APICluster() {
    }

    public APICluster(Long id, String name, String url, String jenkinsUrl, String pluginVersion, State state, LocalDateTime stateTime, LocalDateTime stateChangeTime, Boolean enabled, Type type, String ipAddress, String region, String location) {
        super(id);
        this.name = name;
        this.url = url;
        this.jenkinsUrl = jenkinsUrl;
        this.state = state;
        this.stateTime = TimeConverter.toDate(stateTime);
        this.stateChangeTime = TimeConverter.toDate(stateChangeTime);
        this.enabled = enabled;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.ipAddress = ipAddress;
        this.region = region;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public APICluster setName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public APICluster setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public APICluster setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
        return this;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public APICluster setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
        return this;
    }

    public State getState() {
        return this.state;
    }

    public APICluster setState(State state) {
        this.state = state;
        return this;
    }

    public Date getStateTime() {
        return this.stateTime;
    }

    public APICluster setStateTime(Date stateTime) {
        this.stateTime = stateTime;
        return this;
    }

    public Date getStateChangeTime() {
        return this.stateChangeTime;
    }

    public APICluster setStateChangeTime(Date stateChangeTime) {
        this.stateChangeTime = stateChangeTime;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public APICluster setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public APIList<APIAdminDevice> getDevices() {
        return this.devices;
    }

    public APICluster setDevices(APIList<APIAdminDevice> devices) {
        this.devices = devices;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public APICluster setType(Type type) {
        this.type = type;
        return this;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public APICluster setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public APICluster setRegion(String region) {
        this.region = region;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public APICluster setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APICluster apiCluster = (APICluster)from;
        this.cloneBase(from);
        this.devices = apiCluster.devices;
        this.enabled = apiCluster.enabled;
        this.name = apiCluster.name;
        this.state = apiCluster.state;
        this.stateChangeTime = apiCluster.stateChangeTime;
        this.stateTime = apiCluster.stateTime;
        this.url = apiCluster.url;
        this.jenkinsUrl = apiCluster.jenkinsUrl;
        this.pluginVersion = apiCluster.pluginVersion;
        this.type = apiCluster.type;
        this.ipAddress = apiCluster.ipAddress;
        this.region = apiCluster.region;
        this.location = apiCluster.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APICluster)) {
            return false;
        }
        APICluster cluster = (APICluster)o;
        return new EqualsBuilder().append((Object)this.enabled, (Object)cluster.enabled).append((Object)this.name, (Object)cluster.name).append((Object)this.state, (Object)cluster.state).append((Object)this.stateChangeTime, (Object)cluster.stateChangeTime).append((Object)this.stateTime, (Object)cluster.stateTime).append((Object)this.url, (Object)cluster.url).append((Object)this.jenkinsUrl, (Object)cluster.jenkinsUrl).append((Object)this.pluginVersion, (Object)cluster.pluginVersion).append((Object)this.type, (Object)cluster.type).append((Object)this.ipAddress, (Object)cluster.ipAddress).append((Object)this.region, (Object)cluster.region).append((Object)this.location, (Object)cluster.location).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.enabled).append((Object)this.name).append((Object)this.state).append((Object)this.stateChangeTime).append((Object)this.stateTime).append((Object)this.url).append((Object)this.jenkinsUrl).append((Object)this.pluginVersion).append((Object)this.type).append((Object)this.ipAddress).append((Object)this.region).append((Object)this.location).toHashCode();
    }

    @XmlType(namespace="APICluster", name="APIClusterType")
    public static enum Type {
        BARE_METAL,
        EC2,
        VM;

    }

    @XmlType(namespace="APICluster", name="APIClusterState")
    public static enum State {
        OFFLINE,
        ONLINE,
        RESTARTING,
        QUIET_DOWN,
        MAINTENANCE;

    }
}

