/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIList;
import com.testdroid.api.model.APIBrowser;
import com.testdroid.api.model.APIDeviceProperty;
import com.testdroid.api.model.APISoftwareVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

public class APIDevice
extends APIEntity {
    private Integer creditsPrice;
    private String displayName;
    private String frame100Url;
    private String frame160Url;
    private String frame400Url;
    private String frame80Url;
    private Integer frameExtraWidth;
    private Integer imageHeight;
    private Integer imageLeft;
    private String imagePrefix;
    private Integer imageTop;
    private Integer imageWidth;
    private String manufacturer;
    private Boolean locked;
    private Boolean online;
    private OsType osType;
    private Platform platform;
    private APISoftwareVersion softwareVersion;
    private Boolean enabled;
    private Long accountId;
    private String mainUserEmail;
    private APIList<APIDeviceProperty> properties;
    private APIList<APIBrowser> browsers;
    private DeviceGroupOrigin deviceGroupOrigin;
    private boolean available;
    private Set<Creator> supportedCreators;

    public APIDevice() {
    }

    public APIDevice(Long id, String displayName, String manufacturer, String releaseVersion, Integer apiLevel, Integer creditsPrice, String imagePrefix, Integer imageTop, Integer imageLeft, Integer imageWidth, Integer imageHeight, Integer frameExtraWidth, OsType osType, Platform platform, Boolean online, Boolean locked, Boolean enabled, Long accountId, String mainUserEmail) {
        super(id);
        this.displayName = displayName;
        this.manufacturer = manufacturer;
        this.softwareVersion = new APISoftwareVersion(releaseVersion, apiLevel);
        this.creditsPrice = creditsPrice;
        this.imagePrefix = imagePrefix;
        this.imageTop = imageTop;
        this.imageLeft = imageLeft;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.frameExtraWidth = frameExtraWidth;
        this.osType = osType;
        this.platform = platform;
        this.locked = locked;
        this.online = online;
        this.enabled = enabled;
        this.accountId = accountId;
        this.mainUserEmail = mainUserEmail;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public APISoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(APISoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Integer getCreditsPrice() {
        return this.creditsPrice;
    }

    public void setCreditsPrice(Integer creditsPrice) {
        this.creditsPrice = creditsPrice;
    }

    public String getImagePrefix() {
        return this.imagePrefix;
    }

    public void setImagePrefix(String imagePrefix) {
        this.imagePrefix = imagePrefix;
    }

    public Integer getImageTop() {
        return this.imageTop;
    }

    public void setImageTop(Integer imageTop) {
        this.imageTop = imageTop;
    }

    public Integer getImageLeft() {
        return this.imageLeft;
    }

    public void setImageLeft(Integer imageLeft) {
        this.imageLeft = imageLeft;
    }

    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public Integer getFrameExtraWidth() {
        return this.frameExtraWidth;
    }

    public void setFrameExtraWidth(Integer frameExtraWidth) {
        this.frameExtraWidth = frameExtraWidth;
    }

    public OsType getOsType() {
        return this.osType;
    }

    public void setOsType(OsType osType) {
        this.osType = osType;
    }

    public String getFrame80Url() {
        return this.frame80Url;
    }

    public void setFrame80Url(String frame80Url) {
        this.frame80Url = frame80Url;
    }

    public String getFrame100Url() {
        return this.frame100Url;
    }

    public void setFrame100Url(String frame100Url) {
        this.frame100Url = frame100Url;
    }

    public String getFrame160Url() {
        return this.frame160Url;
    }

    public void setFrame160Url(String frame160Url) {
        this.frame160Url = frame160Url;
    }

    public String getFrame400Url() {
        return this.frame400Url;
    }

    public void setFrame400Url(String frame400Url) {
        this.frame400Url = frame400Url;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Boolean isOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getMainUserEmail() {
        return this.mainUserEmail;
    }

    public void setMainUserEmail(String mainUserEmail) {
        this.mainUserEmail = mainUserEmail;
    }

    public APIList<APIDeviceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(APIList<APIDeviceProperty> properties) {
        this.properties = properties;
    }

    public APIList<APIBrowser> getBrowsers() {
        return this.browsers;
    }

    public void setBrowsers(APIList<APIBrowser> browsers) {
        this.browsers = browsers;
    }

    public DeviceGroupOrigin getDeviceGroupOrigin() {
        return this.deviceGroupOrigin;
    }

    public void setDeviceGroupOrigin(DeviceGroupOrigin deviceGroupOrigin) {
        this.deviceGroupOrigin = deviceGroupOrigin;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setSupportedCreators(Set<Creator> supportedCreators) {
        this.supportedCreators = supportedCreators;
    }

    public Set<Creator> getSupportedCreators() {
        return this.supportedCreators;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIDevice apiDevice = (APIDevice)from;
        this.cloneBase(from);
        this.creditsPrice = apiDevice.creditsPrice;
        this.displayName = apiDevice.displayName;
        this.manufacturer = apiDevice.manufacturer;
        this.frame80Url = apiDevice.frame80Url;
        this.frame100Url = apiDevice.frame100Url;
        this.frame160Url = apiDevice.frame160Url;
        this.frame400Url = apiDevice.frame400Url;
        this.frameExtraWidth = apiDevice.frameExtraWidth;
        this.imageHeight = apiDevice.imageHeight;
        this.imageLeft = apiDevice.imageLeft;
        this.imagePrefix = apiDevice.imagePrefix;
        this.imageTop = apiDevice.imageTop;
        this.imageWidth = apiDevice.imageWidth;
        this.osType = apiDevice.osType;
        this.platform = apiDevice.platform;
        this.softwareVersion = apiDevice.softwareVersion;
        this.online = apiDevice.online;
        this.locked = apiDevice.locked;
        this.enabled = apiDevice.enabled;
        this.accountId = apiDevice.accountId;
        this.mainUserEmail = apiDevice.mainUserEmail;
        this.deviceGroupOrigin = apiDevice.deviceGroupOrigin;
        this.properties = apiDevice.properties;
        this.browsers = apiDevice.browsers;
        this.available = apiDevice.available;
        this.supportedCreators = apiDevice.supportedCreators;
    }

    @XmlType(namespace="APIDevice")
    public static enum OsType {
        IOS("iOS"),
        ANDROID("Android"),
        DESKTOP("Desktop"),
        UNDEFINED("Undefined");

        private final String displayName;
        public static final List<OsType> MOBILES;
        public static final List<OsType> DESKTOPS;

        private OsType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isAndroid() {
            return this == ANDROID;
        }

        public boolean isIos() {
            return this == IOS;
        }

        public boolean isDesktop() {
            return this == DESKTOP;
        }

        public List<OsType> getFamily() {
            return this.isDesktop() ? Collections.singletonList(this) : Arrays.asList(IOS, ANDROID);
        }

        static {
            MOBILES = Arrays.asList(ANDROID, IOS);
            DESKTOPS = Collections.singletonList(DESKTOP);
        }
    }

    @XmlType(namespace="APIDevice")
    public static enum Platform {
        IOS(OsType.IOS),
        ANDROID(OsType.ANDROID),
        WINDOWS(OsType.DESKTOP, "Windows"),
        MAC(OsType.DESKTOP, "macOS"),
        LINUX(OsType.DESKTOP, "Linux"),
        UNDEFINED(OsType.UNDEFINED);

        private final OsType osType;
        private final String displayName;

        private Platform(OsType osType) {
            this(osType, osType.getDisplayName());
        }

        private Platform(OsType osType, String displayName) {
            this.osType = osType;
            this.displayName = displayName;
        }

        public OsType getOsType() {
            return this.osType;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static Platform getByDisplayName(String displayName) {
            return Arrays.stream(Platform.values()).filter(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getDisplayName(), (CharSequence)displayName)).findAny().orElse(UNDEFINED);
        }
    }

    public static enum Creator {
        MANUAL,
        ROBOT,
        AUTOMATIC;

    }

    public static enum DeviceGroupOrigin {
        STATIC,
        DYNAMIC,
        HYBRID;

    }
}

