/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIUserFile;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlType;

public class APIFramework
extends APIEntity {
    private Long accountId;
    private Boolean canRunFromUI;
    private Date createTime = new Date();
    private String description;
    private Boolean forProjects;
    private String mainUserEmail;
    private String name;
    private APIDevice.OsType osType;
    private String requiredAppExtensions;
    private String requiredTestExtensions;
    private String documentationUrl;
    private String requiredTestFileTags;
    private Boolean retryable;
    private Boolean secured;
    private Boolean skipOlderSdk;
    private Boolean skipQueue;
    private String type;
    private Long labelId;
    private String labelName;
    private String icon;
    private APIUserFile sampleApp;
    private APIUserFile sampleTest;

    public APIFramework() {
    }

    public APIFramework(Long id, LocalDateTime createTime, String name, String description, APIDevice.OsType osType, String type, Long accountId, String mainUserEmail, String requiredAppExtensions, String requiredTestExtensions, String requiredTestFileTags, String documentationUrl, Boolean forProjects, Boolean canRunFromUI, Boolean secured, Boolean retryable, Boolean skipQueue, Boolean skipOlderSdk, Long labelId, String labelName, String icon, Long sampleAppId, Long sampleTestId) {
        super(id);
        this.createTime = TimeConverter.toDate(createTime);
        this.name = name;
        this.description = description;
        this.osType = osType;
        this.type = type;
        this.accountId = accountId;
        this.mainUserEmail = mainUserEmail;
        this.requiredAppExtensions = requiredAppExtensions;
        this.requiredTestExtensions = requiredTestExtensions;
        this.requiredTestFileTags = requiredTestFileTags;
        this.documentationUrl = documentationUrl;
        this.forProjects = forProjects;
        this.canRunFromUI = canRunFromUI;
        this.secured = secured;
        this.retryable = retryable;
        this.skipQueue = skipQueue;
        this.skipOlderSdk = skipOlderSdk;
        this.labelId = labelId;
        this.labelName = labelName;
        this.icon = icon;
        this.sampleApp = new APIUserFile(sampleAppId);
        this.sampleTest = new APIUserFile(sampleTestId);
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public APIDevice.OsType getOsType() {
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getRequiredAppExtensions() {
        return this.requiredAppExtensions;
    }

    public void setRequiredAppExtensions(String requiredAppExtensions) {
        this.requiredAppExtensions = requiredAppExtensions;
    }

    public String getRequiredTestExtensions() {
        return this.requiredTestExtensions;
    }

    public void setRequiredTestExtensions(String requiredTestExtensions) {
        this.requiredTestExtensions = requiredTestExtensions;
    }

    public String getRequiredTestFileTags() {
        return this.requiredTestFileTags;
    }

    public void setRequiredTestFileTags(String requiredTestFileTags) {
        this.requiredTestFileTags = requiredTestFileTags;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public Boolean getForProjects() {
        return this.forProjects;
    }

    public void setForProjects(Boolean forProjects) {
        this.forProjects = forProjects;
    }

    public Boolean getCanRunFromUI() {
        return this.canRunFromUI;
    }

    public void setCanRunFromUI(Boolean canRunFromUI) {
        this.canRunFromUI = canRunFromUI;
    }

    public String getMainUserEmail() {
        return this.mainUserEmail;
    }

    public void setMainUserEmail(String mainUserEmail) {
        this.mainUserEmail = mainUserEmail;
    }

    public Boolean getSecured() {
        return this.secured;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public void setRetryable(Boolean retryable) {
        this.retryable = retryable;
    }

    public Boolean getSkipOlderSdk() {
        return this.skipOlderSdk;
    }

    public void setSkipOlderSdk(Boolean skipOlderSdk) {
        this.skipOlderSdk = skipOlderSdk;
    }

    public Boolean getSkipQueue() {
        return this.skipQueue;
    }

    public void setSkipQueue(Boolean skipQueue) {
        this.skipQueue = skipQueue;
    }

    public Long getLabelId() {
        return this.labelId;
    }

    public void setLabelId(Long labelId) {
        this.labelId = labelId;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public APIUserFile getSampleApp() {
        return this.sampleApp;
    }

    public void setSampleApp(APIUserFile sampleApp) {
        this.sampleApp = sampleApp;
    }

    public APIUserFile getSampleTest() {
        return this.sampleTest;
    }

    public void setSampleTest(APIUserFile sampleTest) {
        this.sampleTest = sampleTest;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIFramework apiFramework = (APIFramework)from;
        this.cloneBase(from);
        this.createTime = apiFramework.createTime;
        this.name = apiFramework.name;
        this.description = apiFramework.description;
        this.osType = apiFramework.osType;
        this.type = apiFramework.type;
        this.accountId = apiFramework.accountId;
        this.mainUserEmail = apiFramework.mainUserEmail;
        this.requiredAppExtensions = apiFramework.requiredAppExtensions;
        this.requiredTestExtensions = apiFramework.requiredTestExtensions;
        this.requiredTestFileTags = apiFramework.requiredTestFileTags;
        this.documentationUrl = apiFramework.documentationUrl;
        this.forProjects = apiFramework.forProjects;
        this.canRunFromUI = apiFramework.canRunFromUI;
        this.secured = apiFramework.secured;
        this.retryable = apiFramework.retryable;
        this.skipQueue = apiFramework.skipQueue;
        this.skipOlderSdk = apiFramework.skipOlderSdk;
        this.labelId = apiFramework.labelId;
        this.labelName = apiFramework.labelName;
        this.icon = apiFramework.icon;
        this.sampleApp = apiFramework.sampleApp;
        this.sampleTest = apiFramework.sampleTest;
    }

    @XmlType(namespace="APIFramework")
    public static enum Type {
        APP_CRAWLER,
        CLIENT_SIDE,
        MANUAL,
        REMOTE;

    }
}

