/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

public class APIRole
extends APIEntity {
    private String addedByEmail;
    private Date expireTime;
    private String name;
    private Integer value;
    private boolean valueCalculated;

    public APIRole() {
    }

    public APIRole(Long id, String name) {
        super(id);
        this.name = name;
    }

    public APIRole(Long parentId, Long id, String name, Integer value, boolean valueCalculated) {
        this(id, name);
        this.parentId = parentId;
        this.value = value;
        this.valueCalculated = valueCalculated;
    }

    public APIRole(Long id, String name, LocalDateTime expireTime, Integer value) {
        this(null, id, name, value, false);
        this.expireTime = TimeConverter.toDate(expireTime);
    }

    public APIRole(Long parentId, Long id, String name, LocalDateTime expireTime, String addedByEmail, Integer value) {
        this(parentId, id, name, value, false);
        this.addedByEmail = addedByEmail;
        this.expireTime = TimeConverter.toDate(expireTime);
    }

    public APIRole(Long parentId, Long id, String name, String addedByEmail) {
        this(id, name);
        this.parentId = parentId;
        this.addedByEmail = addedByEmail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getAddedByEmail() {
        return this.addedByEmail;
    }

    public void setAddedByEmail(String addedByEmail) {
        this.addedByEmail = addedByEmail;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean isValueCalculated() {
        return this.valueCalculated;
    }

    public void setValueCalculated(boolean valueCalculated) {
        this.valueCalculated = valueCalculated;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIRole apiRole = (APIRole)from;
        this.cloneBase(from);
        this.expireTime = apiRole.expireTime;
        this.name = apiRole.name;
        this.addedByEmail = apiRole.addedByEmail;
        this.value = apiRole.value;
        this.valueCalculated = apiRole.valueCalculated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIRole apiRole = (APIRole)o;
        return this.valueCalculated == apiRole.valueCalculated && Objects.equals(this.addedByEmail, apiRole.addedByEmail) && Objects.equals(this.expireTime, apiRole.expireTime) && this.name.equals(apiRole.name) && Objects.equals(this.value, apiRole.value);
    }

    public int hashCode() {
        return Objects.hash(this.addedByEmail, this.expireTime, this.name, this.value, this.valueCalculated);
    }
}

