/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.model.APIUserFileProperty;
import com.testdroid.api.model.APIUserFileTag;
import com.testdroid.api.util.TimeConverter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlType;

public class APIUserFile
extends APIEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long VIRUS_SCAN_TIMEOUT_DEFAULT = 300000L;
    private static final Set<String> VIRUS_SCAN_ACCEPTED_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(APIUserFileProperty.VirusScanStatus.safe.name(), APIUserFileProperty.VirusScanStatus.disabled.name(), null)));
    private Date createTime;
    private List<APIUserFileProperty> fileProperties;
    private State state;
    private String name;
    private Long size;
    private URL directUrl;
    private URL iconDirectUrl;
    private String mimetype;
    private Direction direction;
    private InputType inputType;
    private boolean duplicate;
    private String userEmail;
    private Long userId;
    private boolean isShared;
    private transient String uri;
    private transient String iconUri;

    public APIUserFile() {
    }

    public APIUserFile(Long id) {
        super(id);
    }

    public APIUserFile(Long id, String name, LocalDateTime createTime, Long size, State state, String uri, String iconUri, String mimetype, Direction direction, InputType inputType, Long userId, String userEmail, boolean isShared) {
        super(id);
        this.name = name;
        this.createTime = TimeConverter.toDate(createTime);
        this.size = size;
        this.state = state;
        this.uri = uri;
        this.iconUri = iconUri;
        this.mimetype = mimetype;
        this.direction = direction;
        this.inputType = inputType;
        this.userId = userId;
        this.userEmail = userEmail;
        this.isShared = isShared;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public List<APIUserFileProperty> getFileProperties() {
        return this.fileProperties;
    }

    public void setFileProperties(List<APIUserFileProperty> fileProperties) {
        this.fileProperties = fileProperties;
    }

    private String getFileURI() {
        return APIUserFile.createUri(this.selfURI, "/file");
    }

    private String getIconURI() {
        return APIUserFile.createUri(this.selfURI, "/icon");
    }

    private String getFileTagsURI() {
        return APIUserFile.createUri(this.selfURI, "/tags");
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public URL getDirectUrl() {
        return this.directUrl;
    }

    public void setDirectUrl(URL directUrl) {
        this.directUrl = directUrl;
    }

    @JsonIgnore
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public URL getIconDirectUrl() {
        return this.iconDirectUrl;
    }

    public void setIconDirectUrl(URL iconDirectUrl) {
        this.iconDirectUrl = iconDirectUrl;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    @JsonIgnore
    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    @JsonIgnore
    public InputStream getIcon() throws APIException {
        return this.getFile(this.getIconURI());
    }

    @JsonIgnore
    public InputStream getFile() throws APIException {
        return this.getFile(this.getFileURI());
    }

    @JsonIgnore
    public APIListResource<APIUserFileTag> getTagsResource() throws APIException {
        return this.getListResource(this.getFileTagsURI(), APIUserFileTag.class);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    public APIUserFile waitForVirusScan() throws APIException, InterruptedException {
        return this.waitForVirusScan(300000L);
    }

    public APIUserFile waitForVirusScan(long timeout) throws APIException, InterruptedException {
        long end = System.currentTimeMillis() + timeout;
        while (end > System.currentTimeMillis()) {
            this.refresh();
            String virusScanStatus = this.getVirusScanStatus();
            if (APIUserFileProperty.VirusScanStatus.infected.name().equals(virusScanStatus)) {
                throw new APIException(400, "File rejected by virus scan");
            }
            if (VIRUS_SCAN_ACCEPTED_VALUES.contains(virusScanStatus)) {
                return this;
            }
            Thread.sleep(500L);
        }
        throw new APIException(408, "Waiting for virus scan timed out");
    }

    public static void waitForVirusScans(APIUserFile ... files) throws APIException, InterruptedException {
        APIUserFile.waitForVirusScans(300000L, files);
    }

    public static void waitForVirusScans(long timeout, APIUserFile ... files) throws APIException, InterruptedException {
        long end = System.currentTimeMillis() + timeout;
        List filteredFiles = Arrays.stream(files).filter(Objects::nonNull).collect(Collectors.toList());
        while (end > System.currentTimeMillis()) {
            for (APIUserFile file : filteredFiles) {
                if (VIRUS_SCAN_ACCEPTED_VALUES.contains(file.getVirusScanStatus())) continue;
                file.refresh();
            }
            if (filteredFiles.stream().map(APIUserFile::getVirusScanStatus).anyMatch(APIUserFileProperty.VirusScanStatus.infected.name()::equals)) {
                throw new APIException(400, "File rejected by virus scan");
            }
            if (filteredFiles.stream().map(APIUserFile::getVirusScanStatus).allMatch(VIRUS_SCAN_ACCEPTED_VALUES::contains)) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new APIException(408, "Waiting for virus scan timed out");
    }

    private String getVirusScanStatus() {
        return this.getFileProperties().stream().filter(p -> APIUserFileProperty.Key.virus_scan_status.name().equals(p.getKey())).map(APIUserFileProperty::getValue).findAny().orElse(null);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUserFile apiUserFile = (APIUserFile)from;
        this.cloneBase(from);
        this.name = apiUserFile.name;
        this.createTime = apiUserFile.createTime;
        this.size = apiUserFile.size;
        this.fileProperties = apiUserFile.fileProperties;
        this.state = apiUserFile.state;
        this.directUrl = apiUserFile.directUrl;
        this.iconDirectUrl = apiUserFile.iconDirectUrl;
        this.uri = apiUserFile.uri;
        this.iconUri = apiUserFile.iconUri;
        this.direction = apiUserFile.direction;
        this.mimetype = apiUserFile.mimetype;
        this.inputType = apiUserFile.inputType;
        this.userId = apiUserFile.userId;
        this.userEmail = apiUserFile.userEmail;
        this.isShared = apiUserFile.isShared;
    }

    @XmlType(namespace="APIUserFile", name="APIUserFileState")
    public static enum State {
        PREPARING,
        READY;

    }

    @XmlType(namespace="APIUserFile")
    public static enum Direction {
        INPUT,
        OUTPUT;

    }

    @XmlType(namespace="APIUserFile")
    public static enum InputType {
        APPLICATION,
        TEST,
        DATA;

    }
}

