/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model.capabilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.capabilities.APIDesktopBrowser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class APIDesktopPlatform
extends APIEntity {
    private String name;
    private String value;
    private Set<APIDesktopBrowser> browsers = new HashSet<APIDesktopBrowser>();
    private List<String> resolutions = new ArrayList<String>();
    private String version;

    private APIDesktopPlatform() {
    }

    public APIDesktopPlatform(APIDevice.Platform platform, String version) {
        this.name = platform.getDisplayName();
        this.value = platform.name();
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Set<APIDesktopBrowser> getBrowsers() {
        return this.browsers;
    }

    public APIDesktopPlatform setBrowsers(Set<APIDesktopBrowser> browsers) {
        this.browsers = browsers;
        return this;
    }

    public List<String> getResolutions() {
        return this.resolutions;
    }

    public APIDesktopPlatform setResolutions(List<String> resolutions) {
        this.resolutions = resolutions;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public APIDevice.Platform toPlatform() {
        return APIDevice.Platform.getByDisplayName(this.name);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIDesktopPlatform apiDeviceFilterGroup = (APIDesktopPlatform)from;
        this.cloneBase(from);
        this.name = apiDeviceFilterGroup.name;
        this.value = apiDeviceFilterGroup.value;
        this.browsers = apiDeviceFilterGroup.browsers;
        this.resolutions = apiDeviceFilterGroup.resolutions;
        this.version = apiDeviceFilterGroup.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIDesktopPlatform that = (APIDesktopPlatform)o;
        return this.name.equals(that.name) && this.value.equals(that.value) && this.browsers.equals(that.browsers) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.browsers, this.version);
    }
}

