/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.google.common.base.Objects;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.BooleanMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;

public class BooleanMenuItem
extends MenuItem<Boolean> {
    private final BooleanNaming naming;

    public BooleanMenuItem() {
        super("", -1, -1, null);
        this.naming = BooleanNaming.ON_OFF;
    }

    public BooleanMenuItem(String name, int id, int eepromAddress, String functionName, BooleanNaming naming) {
        super(name, id, eepromAddress, functionName);
        this.naming = naming;
    }

    public BooleanNaming getNaming() {
        return this.naming;
    }

    @Override
    public MenuState<Boolean> newMenuState(Boolean value, boolean changed, boolean active) {
        return new BooleanMenuState(changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanMenuItem that = (BooleanMenuItem)o;
        return Objects.equal((Object)((Object)this.naming), (Object)((Object)that.naming)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.functionName, (Object)that.functionName) && this.id == that.id && this.eepromAddress == that.eepromAddress;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.naming, this.eepromAddress, this.name, this.id, this.functionName});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public static enum BooleanNaming {
        ON_OFF,
        YES_NO,
        TRUE_FALSE;

    }
}

