/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.google.common.base.Objects;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Collections;
import java.util.List;

public class EnumMenuItem
extends MenuItem<Integer> {
    private final List<String> enumEntries;

    public EnumMenuItem() {
        super("", -1, -1, null);
        this.enumEntries = Collections.emptyList();
    }

    public EnumMenuItem(String name, int id, int eepromAddress, String functionName, List<String> enumEntries) {
        super(name, id, eepromAddress, functionName);
        this.enumEntries = enumEntries;
    }

    public List<String> getEnumEntries() {
        return this.enumEntries;
    }

    @Override
    public MenuState<Integer> newMenuState(Integer value, boolean changed, boolean active) {
        return new IntegerMenuState(changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumMenuItem that = (EnumMenuItem)o;
        return Objects.equal(this.enumEntries, that.enumEntries) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.eepromAddress, (Object)that.eepromAddress) && Objects.equal((Object)this.functionName, (Object)that.functionName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eepromAddress, this.name, this.id, this.enumEntries, this.functionName});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

