/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.google.common.base.Objects;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;

public class AnalogMenuItem
extends MenuItem<Integer> {
    private final int maxValue;
    private final int offset;
    private final int divisor;
    private final String unitName;

    public AnalogMenuItem() {
        super("", -1, -1, null, false);
        this.maxValue = -1;
        this.offset = -1;
        this.divisor = -1;
        this.unitName = "";
    }

    public AnalogMenuItem(String name, int id, int eepromAddress, String functionName, int maxValue, int offset, int divisor, String unitName, boolean readOnly) {
        super(name, id, eepromAddress, functionName, readOnly);
        this.maxValue = maxValue;
        this.offset = offset;
        this.divisor = divisor;
        this.unitName = unitName;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public String getUnitName() {
        return this.unitName;
    }

    @Override
    public MenuState<Integer> newMenuState(Integer value, boolean changed, boolean active) {
        return new IntegerMenuState(changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalogMenuItem that = (AnalogMenuItem)o;
        return this.maxValue == that.maxValue && this.offset == that.offset && this.divisor == that.divisor && Objects.equal((Object)this.unitName, (Object)that.unitName) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.functionName, (Object)that.functionName) && this.id == that.id && this.eepromAddress == that.eepromAddress;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxValue, this.offset, this.divisor, this.unitName, this.eepromAddress, this.name, this.id, this.functionName});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

