/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.remote.ConnectionChangeListener;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteConnectorListener;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamRemoteConnector
implements RemoteConnector {
    private static final int MAX_MSG_EXPECTED = 1024;
    public static final byte START_OF_MSG = 1;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ScheduledExecutorService executor;
    protected final AtomicReference<StreamState> state = new AtomicReference<StreamState>(StreamState.STARTED);
    private final MenuCommandProtocol protocol;
    private final List<RemoteConnectorListener> connectorListeners = new CopyOnWriteArrayList<RemoteConnectorListener>();
    private final List<ConnectionChangeListener> connectionListeners = new CopyOnWriteArrayList<ConnectionChangeListener>();
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private final ByteBuffer outputBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private final ByteBuffer cmdBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);

    protected StreamRemoteConnector(MenuCommandProtocol protocol, ScheduledExecutorService executor) {
        this.protocol = protocol;
        this.executor = executor;
    }

    protected void processMessagesOnConnection() {
        try {
            this.logger.info("Connected to " + this.getConnectionName());
            this.state.set(StreamState.CONNECTED);
            this.notifyConnection();
            this.inputBuffer.flip();
            while (!Thread.currentThread().isInterrupted() && this.isConnected()) {
                try {
                    byte byStart = 0;
                    while (byStart != 1 && !Thread.currentThread().isInterrupted() && this.isConnected()) {
                        byStart = this.nextByte(this.inputBuffer);
                    }
                    this.readCompleteMessage(this.inputBuffer);
                    if (this.inputBuffer.get() != this.protocol.getKeyIdentifier()) {
                        throw new TcProtocolException("Bad protocol");
                    }
                    this.logByteBuffer("Line read from stream", this.inputBuffer);
                    MenuCommand mc = this.protocol.fromChannel(this.inputBuffer);
                    this.logger.info("Command received: " + mc);
                    this.notifyListeners(mc);
                }
                catch (TcProtocolException ex) {
                    this.logger.warn("Probable Bad message reason='{}' Remote={} ", (Object)ex.getMessage(), (Object)this.getConnectionName());
                }
            }
            this.logger.info("Disconnected from " + this.getConnectionName());
        }
        catch (Exception e) {
            this.logger.error("Problem with connectivity on " + this.getConnectionName(), (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        this.state.set(StreamState.DISCONNECTED);
        this.notifyConnection();
    }

    @Override
    public boolean isConnected() {
        return this.state.get() == StreamState.CONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMenuCommand(MenuCommand msg) throws IOException {
        if (this.isConnected()) {
            ByteBuffer byteBuffer = this.outputBuffer;
            synchronized (byteBuffer) {
                this.cmdBuffer.clear();
                this.protocol.toChannel(this.cmdBuffer, msg);
                this.cmdBuffer.flip();
                this.outputBuffer.clear();
                this.outputBuffer.put((byte)1);
                this.outputBuffer.put(this.protocol.getKeyIdentifier());
                this.outputBuffer.put(this.cmdBuffer);
                this.outputBuffer.flip();
                this.logByteBuffer("Sending message on " + this.getConnectionName(), this.outputBuffer);
                this.sendInternal(this.outputBuffer);
                this.outputBuffer.clear();
            }
        } else {
            throw new IOException("Not connected to port");
        }
    }

    protected abstract void sendInternal(ByteBuffer var1) throws IOException;

    private byte nextByte(ByteBuffer inputBuffer) throws IOException {
        this.getAtLeastBytes(inputBuffer, 1);
        return inputBuffer.get();
    }

    protected abstract void getAtLeastBytes(ByteBuffer var1, int var2) throws IOException;

    protected void readCompleteMessage(ByteBuffer inputBuffer) throws IOException {
        while (!StreamRemoteConnector.doesBufferHaveEOM(inputBuffer)) {
            if (inputBuffer.remaining() > 1024) {
                throw new TcProtocolException("Message corrupt, no EOM");
            }
            this.getAtLeastBytes(inputBuffer, 1);
        }
    }

    @Override
    public void registerConnectorListener(RemoteConnectorListener listener) {
        this.connectorListeners.add(listener);
    }

    @Override
    public void registerConnectionChangeListener(ConnectionChangeListener listener) {
        this.connectionListeners.add(listener);
        this.executor.execute(() -> listener.connectionChange(this, this.isConnected()));
    }

    private void notifyListeners(MenuCommand mc) {
        this.connectorListeners.forEach(listener -> listener.onCommand(this, mc));
    }

    protected void notifyConnection() {
        this.connectionListeners.forEach(listener -> listener.connectionChange(this, this.isConnected()));
    }

    protected void logByteBuffer(String msg, ByteBuffer inBuffer) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        ByteBuffer bb = inBuffer.duplicate();
        byte[] byData = new byte[512];
        int len = Math.min(byData.length, bb.remaining());
        bb.get(byData, 0, len);
        this.logger.debug("{}. Content: '{}'", (Object)msg, (Object)new String(byData, 0, len));
    }

    public static boolean doesBufferHaveEOM(ByteBuffer inputBuffer) {
        ByteBuffer bbCopy = inputBuffer.slice();
        boolean foundMsg = false;
        while (!foundMsg && bbCopy.hasRemaining()) {
            foundMsg = bbCopy.get() == 124 && bbCopy.hasRemaining() && bbCopy.get() == 126;
        }
        return foundMsg;
    }

    public static enum StreamState {
        STARTED,
        CONNECTED,
        DISCONNECTED;

    }
}

