/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.socket;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.RemoteMenuController;
import com.thecoderscorner.menu.remote.protocol.TagValMenuCommandProtocol;
import com.thecoderscorner.menu.remote.socket.SocketBasedConnector;
import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class SocketControllerBuilder {
    private int heartbeatFrequency = 10000;
    private ScheduledExecutorService executorService;
    private MenuTree menuTree;
    private MenuCommandProtocol protocol;
    private Clock clock = Clock.systemDefaultZone();
    private String name = "NoName";
    private String address;
    private int port;

    public SocketControllerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public SocketControllerBuilder withExecutor(ScheduledExecutorService executor) {
        this.executorService = executor;
        return this;
    }

    public SocketControllerBuilder withHeartbeatFrequency(int frequency) {
        this.heartbeatFrequency = frequency;
        return this;
    }

    public SocketControllerBuilder withMenuTree(MenuTree tree) {
        this.menuTree = tree;
        return this;
    }

    public SocketControllerBuilder withProtocol(MenuCommandProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public SocketControllerBuilder withLocalName(String name) {
        this.name = name;
        return this;
    }

    public SocketControllerBuilder withAddress(String address) {
        this.address = address;
        return this;
    }

    public SocketControllerBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public RemoteMenuController build() throws IOException {
        if (this.protocol == null) {
            this.protocol = new TagValMenuCommandProtocol();
        }
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setDaemon(true).build());
        }
        SocketBasedConnector connector = new SocketBasedConnector(this.executorService, this.protocol, this.address, this.port);
        return new RemoteMenuController(connector, this.menuTree, this.executorService, this.name, this.clock, this.heartbeatFrequency);
    }
}

