/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.google.common.base.Objects;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;

public class TextMenuItem
extends MenuItem<String> {
    private final int textLength;

    public TextMenuItem() {
        super("", -1, -1, null, false);
        this.textLength = 0;
    }

    public TextMenuItem(String name, int id, int eepromAddress, String functionName, int length, boolean readOnly) {
        super(name, id, eepromAddress, functionName, readOnly);
        this.textLength = length;
    }

    public int getTextLength() {
        return this.textLength;
    }

    @Override
    public MenuState<String> newMenuState(String value, boolean changed, boolean active) {
        return new StringMenuState(changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMenuItem that = (TextMenuItem)o;
        return Objects.equal((Object)this.textLength, (Object)that.textLength) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.functionName, (Object)that.functionName) && this.id == that.id && this.eepromAddress == that.eepromAddress;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.textLength, this.eepromAddress, this.name, this.id, this.functionName});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

