/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;

public class MenuChangeCommand
implements MenuCommand {
    private final int menuItemId;
    private final int parentItemId;
    private final ChangeType changeType;
    private final String value;

    public MenuChangeCommand(int subMenuId, int menuItemId, ChangeType changeType, String value) {
        this.parentItemId = subMenuId;
        this.menuItemId = menuItemId;
        this.value = value;
        this.changeType = changeType;
    }

    @Override
    public MenuCommandType getCommandType() {
        return MenuCommandType.CHANGE_INT_FIELD;
    }

    public int getMenuItemId() {
        return this.menuItemId;
    }

    public int getParentItemId() {
        return this.parentItemId;
    }

    public String getValue() {
        return this.value;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public static int changeTypeToInt(ChangeType changeType) {
        return changeType == ChangeType.ABSOLUTE ? 1 : 0;
    }

    public static ChangeType changeTypeFromInt(int changeType) {
        return changeType == 0 ? ChangeType.DELTA : ChangeType.ABSOLUTE;
    }

    public String toString() {
        return "MenuChangeCommand{menuItemId=" + this.menuItemId + ", parentItemId=" + this.parentItemId + ", changeType=" + (Object)((Object)this.changeType) + ", value='" + this.value + '\'' + '}';
    }

    public static enum ChangeType {
        ABSOLUTE,
        DELTA;

    }
}

