/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.google.common.base.Objects;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.FloatMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;

public class FloatMenuItem
extends MenuItem<Float> {
    private final int numDecimalPlaces;

    public FloatMenuItem() {
        super("", -1, -1, null, false);
        this.numDecimalPlaces = 0;
    }

    public FloatMenuItem(String name, int id, String functionName, int eepromAddr, int numDecimalPlaces) {
        super(name, id, eepromAddr, functionName, false);
        this.numDecimalPlaces = numDecimalPlaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatMenuItem that = (FloatMenuItem)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.functionName, (Object)that.functionName) && this.id == that.id && this.eepromAddress == that.eepromAddress;
    }

    public int getNumDecimalPlaces() {
        return this.numDecimalPlaces;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eepromAddress, this.name, this.id, this.functionName});
    }

    @Override
    public MenuState<Float> newMenuState(Float value, boolean changed, boolean active) {
        return new FloatMenuState(changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

