/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.google.common.base.Objects;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;

public class RemoteMenuItem
extends MenuItem<String> {
    private final int remoteNum;

    public RemoteMenuItem() {
        super("", -1, -1, null, false);
        this.remoteNum = 0;
    }

    public RemoteMenuItem(String name, int id, int eepromAddr, int remoteNum) {
        super(name, id, eepromAddr, null, false);
        this.remoteNum = remoteNum;
    }

    public int getRemoteNum() {
        return this.remoteNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteMenuItem that = (RemoteMenuItem)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.functionName, (Object)that.functionName) && this.id == that.id && this.eepromAddress == that.eepromAddress;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.eepromAddress, this.name, this.id, this.functionName});
    }

    @Override
    public MenuState<String> newMenuState(String value, boolean changed, boolean active) {
        return new StringMenuState(changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

