/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.google.common.collect.ImmutableMap;
import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.RemoteMenuItem;
import com.thecoderscorner.menu.domain.RemoteMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.domain.TextMenuItem;
import com.thecoderscorner.menu.domain.TextMenuItemBuilder;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.MenuActionBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuAnalogBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBooleanBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuEnumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuFloatBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuRemoteBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuSubBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuTextBootCommand;
import com.thecoderscorner.menu.remote.protocol.ProtocolUtil;
import com.thecoderscorner.menu.remote.protocol.TagValTextParser;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagValMenuCommandProtocol
implements MenuCommandProtocol {
    private static final byte PROTOCOL_TAG_VAL = 1;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, MenuCommandType> codeToCmdType;

    public TagValMenuCommandProtocol() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MenuCommandType ty : MenuCommandType.values()) {
            builder.put((Object)ty.getCode(), (Object)ty);
        }
        this.codeToCmdType = builder.build();
    }

    @Override
    public MenuCommand fromChannel(ByteBuffer buffer) throws IOException {
        TagValTextParser parser = new TagValTextParser(buffer);
        String ty = parser.getValue("MT");
        this.logger.debug("Protocol convert in: {}", (Object)parser);
        MenuCommandType cmdType = this.codeToCmdType.get(ty);
        if (cmdType == null) {
            throw new TcProtocolException("Protocol received unexpected message: " + ty);
        }
        switch (cmdType) {
            case JOIN: {
                return this.processJoin(parser);
            }
            case HEARTBEAT: {
                return this.processHeartbeat(parser);
            }
            case BOOTSTRAP: {
                return this.processBootstrap(parser);
            }
            case ANALOG_BOOT_ITEM: {
                return this.processAnalogBootItem(parser);
            }
            case SUBMENU_BOOT_ITEM: {
                return this.processSubMenuBootItem(parser);
            }
            case ENUM_BOOT_ITEM: {
                return this.processEnumBootItem(parser);
            }
            case BOOLEAN_BOOT_ITEM: {
                return this.processBoolBootItem(parser);
            }
            case CHANGE_INT_FIELD: {
                return this.processItemChange(parser);
            }
            case TEXT_BOOT_ITEM: {
                return this.processTextItem(parser);
            }
            case REMOTE_BOOT_ITEM: {
                return this.processRemoteItem(parser);
            }
            case FLOAT_BOOT_ITEM: {
                return this.processFloatItem(parser);
            }
            case ACTION_BOOT_ITEM: {
                return this.processActionItem(parser);
            }
        }
        throw new TcProtocolException("Unknown message type " + (Object)((Object)cmdType));
    }

    private MenuCommand processItemChange(TagValTextParser parser) throws IOException {
        MenuChangeCommand.ChangeType type = MenuChangeCommand.changeTypeFromInt(parser.getValueAsInt("TC"));
        if (type == MenuChangeCommand.ChangeType.DELTA) {
            return CommandFactory.newDeltaChangeCommand(parser.getValueAsInt("PI"), parser.getValueAsInt("ID"), parser.getValueAsInt("VC"));
        }
        return CommandFactory.newAbsoluteMenuChangeCommand(parser.getValueAsInt("PI"), parser.getValueAsInt("ID"), parser.getValue("VC"));
    }

    private MenuCommand processBoolBootItem(TagValTextParser parser) throws IOException {
        BooleanMenuItem item = ((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withNaming(this.toNaming(parser.getValueAsInt("BN"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newMenuBooleanBootCommand(parentId, item, currentVal != 0);
    }

    private MenuCommand processTextItem(TagValTextParser parser) throws IOException {
        TextMenuItem item = ((TextMenuItemBuilder)((TextMenuItemBuilder)((TextMenuItemBuilder)TextMenuItemBuilder.aTextMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withLength(parser.getValueAsInt("ML")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuTextBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processFloatItem(TagValTextParser parser) throws IOException {
        FloatMenuItem item = ((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)FloatMenuItemBuilder.aFloatMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withDecimalPlaces(parser.getValueAsInt("FD")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuFloatBootCommand(parentId, item, Float.valueOf(currentVal));
    }

    private MenuCommand processRemoteItem(TagValTextParser parser) throws IOException {
        RemoteMenuItem item = ((RemoteMenuItemBuilder)((RemoteMenuItemBuilder)((RemoteMenuItemBuilder)RemoteMenuItemBuilder.aRemoteMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withRemoteNo(parser.getValueAsInt("RN")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuRemoteBootCommand(parentId, item, currentVal);
    }

    private BooleanMenuItem.BooleanNaming toNaming(int i) {
        if (i == 0) {
            return BooleanMenuItem.BooleanNaming.TRUE_FALSE;
        }
        if (i == 1) {
            return BooleanMenuItem.BooleanNaming.ON_OFF;
        }
        return BooleanMenuItem.BooleanNaming.YES_NO;
    }

    private MenuCommand processEnumBootItem(TagValTextParser parser) throws IOException {
        ArrayList<String> choices = new ArrayList<String>();
        int noOfItems = parser.getValueAsInt("NC");
        for (int i = 0; i < noOfItems; ++i) {
            String key = "C" + (char)(i + 65);
            choices.add(parser.getValue(key));
        }
        EnumMenuItem item = ((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)EnumMenuItemBuilder.anEnumMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withEnumList(choices).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newMenuEnumBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processSubMenuBootItem(TagValTextParser parser) throws IOException {
        SubMenuItem item = ((SubMenuItemBuilder)((SubMenuItemBuilder)SubMenuItemBuilder.aSubMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        return CommandFactory.newMenuSubBootCommand(parentId, item);
    }

    private MenuCommand processActionItem(TagValTextParser parser) throws IOException {
        ActionMenuItem item = ((ActionMenuItemBuilder)((ActionMenuItemBuilder)ActionMenuItemBuilder.anActionMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withName(parser.getValue("NM"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        return new MenuActionBootCommand(parentId, item, Boolean.FALSE);
    }

    private MenuCommand processAnalogBootItem(TagValTextParser parser) throws IOException {
        AnalogMenuItem item = ((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withDivisor(parser.getValueAsInt("AD")).withMaxValue(parser.getValueAsInt("AM")).withOffset(parser.getValueAsInt("AO")).withUnit(parser.getValue("AU")).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newAnalogBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processBootstrap(TagValTextParser parser) throws IOException {
        MenuBootstrapCommand.BootType bt = MenuBootstrapCommand.BootType.valueOf(parser.getValue("BT"));
        return new MenuBootstrapCommand(bt);
    }

    private MenuCommand processJoin(TagValTextParser parser) throws IOException {
        return new MenuJoinCommand(parser.getValue("NM"), ProtocolUtil.fromKeyToApiPlatform(parser.getValueAsInt("PF")), parser.getValueAsInt("VE"));
    }

    private MenuCommand processHeartbeat(TagValTextParser parser) {
        return CommandFactory.newHeartbeatCommand();
    }

    @Override
    public void toChannel(ByteBuffer buffer, MenuCommand cmd) {
        StringBuilder sb = new StringBuilder(128);
        this.appendField(sb, "MT", cmd.getCommandType().getCode());
        switch (cmd.getCommandType()) {
            case HEARTBEAT: {
                break;
            }
            case JOIN: {
                this.writeJoin(sb, (MenuJoinCommand)cmd);
                break;
            }
            case BOOTSTRAP: {
                this.writeBootstrap(sb, (MenuBootstrapCommand)cmd);
                break;
            }
            case ANALOG_BOOT_ITEM: {
                this.writeAnalogItem(sb, (MenuAnalogBootCommand)cmd);
                break;
            }
            case SUBMENU_BOOT_ITEM: {
                this.writeSubMenuItem(sb, (MenuSubBootCommand)cmd);
                break;
            }
            case ENUM_BOOT_ITEM: {
                this.writeEnumMenuItem(sb, (MenuEnumBootCommand)cmd);
                break;
            }
            case REMOTE_BOOT_ITEM: {
                this.writeRemoteBootItem(sb, (MenuRemoteBootCommand)cmd);
                break;
            }
            case ACTION_BOOT_ITEM: {
                this.writeActionBootItem(sb, (MenuActionBootCommand)cmd);
                break;
            }
            case FLOAT_BOOT_ITEM: {
                this.writeFloatBootItem(sb, (MenuFloatBootCommand)cmd);
                break;
            }
            case BOOLEAN_BOOT_ITEM: {
                this.writeBoolMenuItem(sb, (MenuBooleanBootCommand)cmd);
                break;
            }
            case CHANGE_INT_FIELD: {
                this.writeChangeInt(sb, (MenuChangeCommand)cmd);
                break;
            }
            case TEXT_BOOT_ITEM: {
                this.writeTextMenuItem(sb, (MenuTextBootCommand)cmd);
            }
        }
        sb.append('~');
        String msgStr = sb.toString();
        this.logger.debug("Protocol convert out: {}", (Object)msgStr);
        buffer.put(msgStr.getBytes());
    }

    @Override
    public byte getKeyIdentifier() {
        return 1;
    }

    private void writeChangeInt(StringBuilder sb, MenuChangeCommand cmd) {
        this.appendField(sb, "PI", cmd.getParentItemId());
        this.appendField(sb, "ID", cmd.getMenuItemId());
        this.appendField(sb, "TC", MenuChangeCommand.changeTypeToInt(cmd.getChangeType()));
        this.appendField(sb, "VC", cmd.getValue());
    }

    private void writeAnalogItem(StringBuilder sb, MenuAnalogBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "AO", ((AnalogMenuItem)cmd.getMenuItem()).getOffset());
        this.appendField(sb, "AD", ((AnalogMenuItem)cmd.getMenuItem()).getDivisor());
        this.appendField(sb, "AM", ((AnalogMenuItem)cmd.getMenuItem()).getMaxValue());
        this.appendField(sb, "AU", ((AnalogMenuItem)cmd.getMenuItem()).getUnitName());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeSubMenuItem(StringBuilder sb, MenuSubBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "VC", "0");
    }

    private void writeActionBootItem(StringBuilder sb, MenuActionBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "VC", "");
    }

    private void writeBoolMenuItem(StringBuilder sb, MenuBooleanBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "BN", this.fromNaming(((BooleanMenuItem)cmd.getMenuItem()).getNaming()));
        this.appendField(sb, "VC", (Boolean)cmd.getCurrentValue() != false ? 1 : 0);
    }

    private void writeCommonBootFields(StringBuilder sb, BootItemMenuCommand cmd) {
        this.appendField(sb, "PI", cmd.getSubMenuId());
        this.appendField(sb, "ID", ((MenuItem)cmd.getMenuItem()).getId());
        this.appendField(sb, "NM", ((MenuItem)cmd.getMenuItem()).getName());
    }

    private void writeRemoteBootItem(StringBuilder sb, MenuRemoteBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "RN", ((RemoteMenuItem)cmd.getMenuItem()).getRemoteNum());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeFloatBootItem(StringBuilder sb, MenuFloatBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "FD", ((FloatMenuItem)cmd.getMenuItem()).getNumDecimalPlaces());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeTextMenuItem(StringBuilder sb, MenuTextBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "ML", ((TextMenuItem)cmd.getMenuItem()).getTextLength());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private int fromNaming(BooleanMenuItem.BooleanNaming naming) {
        switch (naming) {
            case ON_OFF: {
                return 1;
            }
            case YES_NO: {
                return 2;
            }
        }
        return 0;
    }

    private void writeEnumMenuItem(StringBuilder sb, MenuEnumBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "VC", cmd.getCurrentValue());
        List<String> entries = ((EnumMenuItem)cmd.getMenuItem()).getEnumEntries();
        this.appendField(sb, "NC", entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            this.appendField(sb, "C" + (char)(65 + i), entries.get(i));
        }
    }

    private void writeBootstrap(StringBuilder sb, MenuBootstrapCommand cmd) {
        this.appendField(sb, "BT", (Object)cmd.getBootType());
    }

    private void writeJoin(StringBuilder sb, MenuJoinCommand cmd) {
        this.appendField(sb, "NM", cmd.getMyName());
        this.appendField(sb, "VE", cmd.getApiVersion());
        this.appendField(sb, "PF", cmd.getPlatform().getKey());
    }

    private void appendField(StringBuilder sb, String key, Object value) {
        sb.append(key);
        sb.append('=');
        sb.append(value);
        sb.append('|');
    }
}

