/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.rs232;

import com.fazecast.jSerialComm.SerialPort;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;

public class Rs232RemoteConnector
extends StreamRemoteConnector {
    private final String portName;
    private final SerialPort serialPort;
    private final int baud;

    public Rs232RemoteConnector(String portName, int baud, MenuCommandProtocol protocol, ScheduledExecutorService executor) {
        super(protocol, executor);
        this.serialPort = SerialPort.getCommPort((String)portName);
        this.serialPort.setBaudRate(baud);
        this.portName = portName;
        this.baud = baud;
    }

    @Override
    public void start() {
        this.executor.execute(this::threadedReader);
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    private void threadedReader() {
        this.logger.info("RS232 Reading thread started");
        while (!Thread.currentThread().isInterrupted()) {
            if (!this.reconnectWithWait()) continue;
            this.processMessagesOnConnection();
        }
        this.logger.info("RS232 Reading thread ended");
    }

    private boolean reconnectWithWait() {
        try {
            Thread.sleep(500L);
            this.logger.info("Attempting to connect over rs232 to " + this.getConnectionName());
            this.serialPort.openPort();
            this.serialPort.setComPortTimeouts(256, 30000, 30000);
            if (this.serialPort.isOpen()) {
                this.notifyConnection();
            } else {
                Thread.sleep(5000L);
            }
            return this.serialPort.isOpen();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public String getConnectionName() {
        return "Serial " + this.portName + "@" + this.baud;
    }

    @Override
    protected void sendInternal(ByteBuffer outputBuffer) throws IOException {
        byte[] data = new byte[outputBuffer.remaining()];
        outputBuffer.get(data, 0, data.length);
        this.serialPort.getOutputStream().write(data, 0, data.length);
    }

    @Override
    protected void getAtLeastBytes(ByteBuffer inputBuffer, int len) throws IOException {
        do {
            inputBuffer.compact();
            while (this.serialPort.bytesAvailable() > 0) {
                inputBuffer.put((byte)this.serialPort.getInputStream().read());
            }
            inputBuffer.flip();
        } while (inputBuffer.remaining() < len);
    }
}

