/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.udp;

import com.thecoderscorner.menu.remote.ConnectionChangeListener;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteConnectorListener;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpRemoteConnector
implements RemoteConnector {
    private static final short PROTOCOL_TAGVAL = 1;
    private static final int MAX_MSG_SIZE = 128;
    private static final int MAX_PACKET = 1024;
    private static final int MAGIC_KEY = 454356577;
    private static final short MSGFLAG_API_TO_DEV = 1;
    private static final short MSGFLAG_DEV_TO_API = 0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService executor;
    private final long flushFreq;
    private final boolean sendCommandAsDevice;
    private final String address;
    private final MenuCommandProtocol protocol;
    private final short deviceId;
    private final List<RemoteConnectorListener> connectorListeners = new CopyOnWriteArrayList<RemoteConnectorListener>();
    private final List<ConnectionChangeListener> connectionListeners = new CopyOnWriteArrayList<ConnectionChangeListener>();
    private final ByteBuffer inBuffer = ByteBuffer.allocateDirect(4096);
    private final ByteBuffer outBuffer = ByteBuffer.allocate(1014);
    private final DatagramChannel channel;
    private final NetworkInterface networkInterface;
    private AtomicReference<MembershipKey> key = new AtomicReference();

    public UdpRemoteConnector(ScheduledExecutorService executor, long flushFreq, String address, int port, MenuCommandProtocol protocol, short deviceId, boolean sendAsDevice) throws IOException {
        this.executor = executor;
        this.flushFreq = flushFreq;
        this.address = address;
        this.protocol = protocol;
        this.deviceId = deviceId;
        this.sendCommandAsDevice = sendAsDevice;
        String netIfName = "en0";
        this.networkInterface = NetworkInterface.getByName(netIfName);
        if (this.networkInterface == null) {
            throw new IOException("Network interface not found: " + netIfName);
        }
        this.channel = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(port)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.networkInterface);
    }

    @Override
    public void start() {
        this.executor.scheduleAtFixedRate(this::flushNetworkBuffers, this.flushFreq, this.flushFreq, TimeUnit.MILLISECONDS);
        this.executor.execute(this::threadedReader);
    }

    private void threadedReader() {
        try {
            this.logger.info("UDP based socket read thread starting");
            while (!Thread.currentThread().isInterrupted()) {
                if (!this.handleConnection()) continue;
                this.processMessagesOnConnection();
            }
            this.logger.info("UDP based socket read thread ended");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.logger.error("UDP based socket closing because its interrupted", (Throwable)ie);
        }
        catch (Exception e) {
            this.logger.error("UDP based socket closing because of exception", (Throwable)e);
        }
    }

    private void processMessagesOnConnection() {
        try {
            this.notifyConnection();
            while (!Thread.currentThread().isInterrupted() && this.isChannelOpen()) {
                this.inBuffer.clear();
                this.channel.receive(this.inBuffer);
                this.inBuffer.flip();
                this.logProtocolByteBuffer("Processing incoming message", this.inBuffer);
                if (this.inBuffer.remaining() <= 10 || this.inBuffer.getInt() != 454356577 || this.inBuffer.getShort() != this.deviceId || this.inBuffer.getShort() != 1 || this.inBuffer.getShort() != 0) continue;
                while (this.inBuffer.remaining() > 3 && this.inBuffer.get() == 96) {
                    MenuCommand mc = this.protocol.fromChannel(this.inBuffer);
                    this.logger.info("Command received: " + mc);
                    this.notifyListeners(mc);
                }
            }
            this.logger.info("Disconnected from network");
        }
        catch (Exception e) {
            this.logger.error("Disconnected from network with exception", (Throwable)e);
        }
        finally {
            this.silentlyCloseChannel();
        }
    }

    private void logProtocolByteBuffer(String msg, ByteBuffer buffer) {
        if (!this.logger.isDebugEnabled() || buffer.remaining() < 10) {
            return;
        }
        ByteBuffer bb = buffer.duplicate();
        int magic = bb.getInt();
        short devId = bb.getShort();
        short proto = bb.getShort();
        boolean toApi = bb.getShort() == 0;
        byte[] byData = new byte[2048];
        int len = Math.min(256, bb.remaining());
        bb.get(byData, 0, len);
        this.logger.debug("{}. Magic:{}, Device:{}, Proto:{}, ToAPI:{}, Content: '{}'", new Object[]{msg, magic, (int)devId, (int)proto, toApi, new String(byData, 0, len)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNetworkBuffers() {
        if (this.isChannelOpen()) {
            ByteBuffer byteBuffer = this.outBuffer;
            synchronized (byteBuffer) {
                if (this.outBuffer.position() == 0) {
                    return;
                }
                this.outBuffer.flip();
                ByteBuffer writeBuffer = ByteBuffer.allocate(1044);
                writeBuffer.putInt(454356577);
                writeBuffer.putShort(this.deviceId);
                writeBuffer.putShort((short)1);
                writeBuffer.putShort(this.sendCommandAsDevice ? (short)0 : 1);
                writeBuffer.put(this.outBuffer);
                writeBuffer.flip();
                this.logProtocolByteBuffer("Writing to stream: ", writeBuffer);
                this.outBuffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMenuCommand(MenuCommand msg) throws IOException {
        if (!this.isChannelOpen()) {
            throw new IOException("Unable to send message because socket was closed " + msg);
        }
        ByteBuffer byteBuffer = this.outBuffer;
        synchronized (byteBuffer) {
            if (this.outBuffer.remaining() < 128) {
                this.flushNetworkBuffers();
            }
            this.outBuffer.put((byte)96);
            this.protocol.toChannel(this.outBuffer, msg);
            this.logger.debug("Added command to buffer for send, remaining " + this.outBuffer.remaining());
        }
    }

    private boolean isChannelOpen() {
        return this.channel.isOpen() && this.key.get() != null;
    }

    private void notifyListeners(MenuCommand mc) {
        for (RemoteConnectorListener connectorListener : this.connectorListeners) {
            connectorListener.onCommand(this, mc);
        }
    }

    private void notifyConnection() {
        boolean connected = this.isChannelOpen();
        for (ConnectionChangeListener connectionListener : this.connectionListeners) {
            connectionListener.connectionChange(this, connected);
        }
    }

    private void silentlyCloseChannel() {
        MembershipKey membershipKey = this.key.get();
        if (this.channel.isOpen() && membershipKey != null) {
            this.logger.info("Channel was open, closing now and dropping multicast subscription");
            membershipKey.drop();
            this.key.set(null);
        }
    }

    private boolean handleConnection() throws InterruptedException {
        try {
            if (this.channel.isOpen() && this.channel.isConnected()) {
                this.key.set(this.channel.join(InetAddress.getByName(this.address), this.networkInterface));
            }
            return true;
        }
        catch (IOException e) {
            this.logger.error("Unable to open socket connection", (Throwable)e);
            Thread.sleep(5000L);
            return false;
        }
    }

    @Override
    public void stop() {
        this.silentlyCloseChannel();
        this.executor.shutdownNow();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isOpen();
    }

    @Override
    public String getConnectionName() {
        return "UDP:" + this.address;
    }

    @Override
    public void registerConnectorListener(RemoteConnectorListener listener) {
        this.connectorListeners.add(listener);
    }

    @Override
    public void registerConnectionChangeListener(ConnectionChangeListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void close() {
        this.silentlyCloseChannel();
    }
}

