/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class AnalogMenuItem
extends MenuItem<Integer> {
    private final int maxValue;
    private final int offset;
    private final int divisor;
    private final String unitName;

    public AnalogMenuItem() {
        super("", -1, -1, null, false);
        this.maxValue = -1;
        this.offset = -1;
        this.divisor = -1;
        this.unitName = "";
    }

    public AnalogMenuItem(String name, int id, int eepromAddress, String functionName, int maxValue, int offset, int divisor, String unitName, boolean readOnly) {
        super(name, id, eepromAddress, functionName, readOnly);
        this.maxValue = maxValue;
        this.offset = offset;
        this.divisor = divisor;
        this.unitName = unitName;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public String getUnitName() {
        return this.unitName;
    }

    @Override
    public MenuState<Integer> newMenuState(Integer value, boolean changed, boolean active) {
        return new IntegerMenuState(changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalogMenuItem that = (AnalogMenuItem)o;
        return this.getMaxValue() == that.getMaxValue() && this.getOffset() == that.getOffset() && this.getDivisor() == that.getDivisor() && Objects.equals(this.getName(), that.getName()) && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && Objects.equals(this.getUnitName(), that.getUnitName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.getMaxValue(), this.getOffset(), this.getDivisor(), this.getUnitName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly());
    }
}

