/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.FloatMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class FloatMenuItem
extends MenuItem<Float> {
    private final int numDecimalPlaces;

    public FloatMenuItem() {
        super("", -1, -1, null, false);
        this.numDecimalPlaces = 0;
    }

    public FloatMenuItem(String name, int id, String functionName, int eepromAddr, int numDecimalPlaces) {
        super(name, id, eepromAddr, functionName, false);
        this.numDecimalPlaces = numDecimalPlaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatMenuItem that = (FloatMenuItem)o;
        return this.getNumDecimalPlaces() == that.getNumDecimalPlaces() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.getNumDecimalPlaces(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName());
    }

    public int getNumDecimalPlaces() {
        return this.numDecimalPlaces;
    }

    @Override
    public MenuState<Float> newMenuState(Float value, boolean changed, boolean active) {
        return new FloatMenuState(changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

