/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class RemoteMenuItem
extends MenuItem<String> {
    private final int remoteNum;

    public RemoteMenuItem() {
        super("", -1, -1, null, false);
        this.remoteNum = 0;
    }

    public RemoteMenuItem(String name, int id, int eepromAddr, int remoteNum) {
        super(name, id, eepromAddr, null, false);
        this.remoteNum = remoteNum;
    }

    public int getRemoteNum() {
        return this.remoteNum;
    }

    @Override
    public MenuState<String> newMenuState(String value, boolean changed, boolean active) {
        return new StringMenuState(changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteMenuItem that = (RemoteMenuItem)o;
        return this.getRemoteNum() == that.getRemoteNum() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.getRemoteNum(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly());
    }
}

