/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class TextMenuItem
extends MenuItem<String> {
    private final int textLength;

    public TextMenuItem() {
        super("", -1, -1, null, false);
        this.textLength = 0;
    }

    public TextMenuItem(String name, int id, int eepromAddress, String functionName, int length, boolean readOnly) {
        super(name, id, eepromAddress, functionName, readOnly);
        this.textLength = length;
    }

    public int getTextLength() {
        return this.textLength;
    }

    @Override
    public MenuState<String> newMenuState(String value, boolean changed, boolean active) {
        return new StringMenuState(changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMenuItem that = (TextMenuItem)o;
        return this.getTextLength() == that.getTextLength() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.getTextLength(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName());
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

