/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.util;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.RemoteMenuItem;
import com.thecoderscorner.menu.domain.RemoteMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.domain.TextMenuItem;
import com.thecoderscorner.menu.domain.TextMenuItemBuilder;
import com.thecoderscorner.menu.domain.util.AbstractMenuItemVisitor;
import java.util.Optional;

public class MenuItemHelper {
    public static <T> Optional<T> visitWithResult(MenuItem item, AbstractMenuItemVisitor<T> visitor) {
        item.accept(visitor);
        return visitor.getResult();
    }

    public static SubMenuItem asSubMenu(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<SubMenuItem>(){

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(item);
            }

            @Override
            public void anyItem(MenuItem item) {
            }
        }).orElse(null);
    }

    public static MenuItem createFromExistingWithId(MenuItem selected, final int newId) {
        return MenuItemHelper.visitWithResult(selected, new AbstractMenuItemVisitor<MenuItem>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(((AnalogMenuItemBuilder)AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(((EnumMenuItemBuilder)EnumMenuItemBuilder.anEnumMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(((SubMenuItemBuilder)SubMenuItemBuilder.aSubMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(TextMenuItem item) {
                this.setResult(((TextMenuItemBuilder)TextMenuItemBuilder.aTextMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(RemoteMenuItem item) {
                this.setResult(((RemoteMenuItemBuilder)RemoteMenuItemBuilder.aRemoteMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(FloatMenuItem item) {
                this.setResult(((FloatMenuItemBuilder)FloatMenuItemBuilder.aFloatMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(ActionMenuItem item) {
                this.setResult(((ActionMenuItemBuilder)ActionMenuItemBuilder.anActionMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }
        }).orElse(null);
    }

    public static int eepromSizeForItem(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Integer>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(1);
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(TextMenuItem item) {
                this.setResult(item.getTextLength());
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(0);
            }
        }).orElse(0);
    }
}

