/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.RemoteMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.TextMenuItem;
import com.thecoderscorner.menu.remote.commands.MenuActionBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuAnalogBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBooleanBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuEnumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuFloatBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuRemoteBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuSubBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuTextBootCommand;
import com.thecoderscorner.menu.remote.protocol.ApiPlatform;
import com.thecoderscorner.menu.remote.protocol.ProtocolUtil;

public class CommandFactory {
    public static MenuJoinCommand newJoinCommand(String name) {
        return new MenuJoinCommand(name, ApiPlatform.JAVA_API, ProtocolUtil.getVersionFromProperties());
    }

    public static MenuHeartbeatCommand newHeartbeatCommand() {
        return new MenuHeartbeatCommand();
    }

    public static MenuBootstrapCommand newBootstrapCommand(MenuBootstrapCommand.BootType type) {
        return new MenuBootstrapCommand(type);
    }

    public static MenuAnalogBootCommand newAnalogBootCommand(int parentId, AnalogMenuItem item, int currentVal) {
        return new MenuAnalogBootCommand(parentId, item, currentVal);
    }

    public static MenuSubBootCommand newMenuSubBootCommand(int parentId, SubMenuItem item) {
        return new MenuSubBootCommand(parentId, item, false);
    }

    public static MenuEnumBootCommand newMenuEnumBootCommand(int parentId, EnumMenuItem item, int currentVal) {
        return new MenuEnumBootCommand(parentId, item, currentVal);
    }

    public static MenuBooleanBootCommand newMenuBooleanBootCommand(int parentId, BooleanMenuItem item, boolean currentVal) {
        return new MenuBooleanBootCommand(parentId, item, currentVal);
    }

    public static MenuFloatBootCommand newMenuFloatBootCommand(int parentId, FloatMenuItem item, Float currentVal) {
        return new MenuFloatBootCommand(parentId, item, currentVal);
    }

    public static MenuRemoteBootCommand newMenuRemoteBootCommand(int parentId, RemoteMenuItem item, String currentVal) {
        return new MenuRemoteBootCommand(parentId, item, currentVal);
    }

    public static MenuActionBootCommand newMenuActionBootCommand(int parentId, ActionMenuItem item) {
        return new MenuActionBootCommand(parentId, item, false);
    }

    public static MenuTextBootCommand newMenuTextBootCommand(int parentId, TextMenuItem item, String currentVal) {
        return new MenuTextBootCommand(parentId, item, currentVal);
    }

    public static MenuChangeCommand newDeltaChangeCommand(int parentId, int item, int value) {
        return new MenuChangeCommand(parentId, item, MenuChangeCommand.ChangeType.DELTA, Integer.toString(value));
    }

    public static MenuChangeCommand newAbsoluteMenuChangeCommand(int parentId, int item, Object value) {
        return new MenuChangeCommand(parentId, item, MenuChangeCommand.ChangeType.ABSOLUTE, value.toString());
    }
}

