/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.udp;

import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.NamedDaemonThreadFactory;
import com.thecoderscorner.menu.remote.RemoteMenuController;
import com.thecoderscorner.menu.remote.protocol.TagValMenuCommandProtocol;
import com.thecoderscorner.menu.remote.udp.UdpRemoteConnector;
import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class UdpControllerBuilder {
    private short deviceId;
    private int heartbeatFrequency = 10000;
    private ScheduledExecutorService executorService;
    private MenuTree menuTree;
    private MenuCommandProtocol protocol;
    private Clock clock = Clock.systemDefaultZone();
    private String name = "NoName";
    private long sendFreq = 100L;
    private String address;
    private int port;
    private boolean sendAsDevice;

    public UdpControllerBuilder withDeviceId(short deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public UdpControllerBuilder withSendFreq(long sendFreq) {
        this.sendFreq = sendFreq;
        return this;
    }

    public UdpControllerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public UdpControllerBuilder withExecutor(ScheduledExecutorService executor) {
        this.executorService = executor;
        return this;
    }

    public UdpControllerBuilder withHeartbeatFrequency(int frequency) {
        this.heartbeatFrequency = frequency;
        return this;
    }

    public UdpControllerBuilder withMenuTree(MenuTree tree) {
        this.menuTree = tree;
        return this;
    }

    public UdpControllerBuilder withProtocol(MenuCommandProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public UdpControllerBuilder withSendAsDevice(boolean asDevice) {
        this.sendAsDevice = asDevice;
        return this;
    }

    public UdpControllerBuilder withLocalName(String name) {
        this.name = name;
        return this;
    }

    public UdpControllerBuilder withBindAddress(String address) {
        this.address = address;
        return this;
    }

    public UdpControllerBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public RemoteMenuController build() throws IOException {
        if (this.protocol == null) {
            this.protocol = new TagValMenuCommandProtocol();
        }
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2, new NamedDaemonThreadFactory("udp-remote"));
        }
        UdpRemoteConnector connector = new UdpRemoteConnector(this.executorService, this.sendFreq, this.address, this.port, this.protocol, this.deviceId, this.sendAsDevice);
        return new RemoteMenuController(connector, this.menuTree, this.executorService, this.name, this.clock, this.heartbeatFrequency);
    }
}

