/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class TagValTextParser {
    private Map<String, String> keyToValue = new HashMap<String, String>(32);

    public TagValTextParser(ByteBuffer buffer) throws IOException {
        boolean foundEnd = false;
        while (buffer.hasRemaining() && !foundEnd) {
            String key = this.readString(buffer);
            if (key.equals("~")) {
                foundEnd = true;
                continue;
            }
            if (key.isEmpty()) {
                throw new TcProtocolException("Key is empty in protocol");
            }
            String value = this.readString(buffer);
            if (value.equals("~")) {
                foundEnd = true;
            }
            this.keyToValue.put(key, value);
        }
    }

    private String readString(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder(32);
        while (buffer.hasRemaining()) {
            char ch = (char)buffer.get();
            if (ch == '~') {
                return sb.append(ch).toString();
            }
            if (ch == '\\') {
                ch = (char)buffer.get();
                sb.append(ch);
                continue;
            }
            if (ch == '=' || ch == '|') {
                return sb.toString();
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public String getValue(String keyMsgType) throws IOException {
        if (this.keyToValue.containsKey(keyMsgType)) {
            return this.keyToValue.get(keyMsgType);
        }
        throw new IOException("Key " + keyMsgType + " doesn't exist in " + this.keyToValue);
    }

    public String getValueWithDefault(String keyMsgType, String defaultVal) {
        return this.keyToValue.getOrDefault(keyMsgType, defaultVal);
    }

    public int getValueAsInt(String keyIdField) throws IOException {
        return Integer.parseInt(this.getValue(keyIdField));
    }

    public int getValueAsIntWithDefault(String keyIdField, int defaultVal) throws IOException {
        if (this.keyToValue.containsKey(keyIdField)) {
            return Integer.parseInt(this.getValue(keyIdField));
        }
        return defaultVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        this.keyToValue.forEach((k, v) -> sb.append("[Key='").append((String)k).append("', val='").append((String)v).append("'] "));
        return sb.toString();
    }
}

