/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.state;

import com.thecoderscorner.menu.domain.MenuItem;
import java.util.Objects;

public abstract class MenuState<T> {
    private final boolean changed;
    private final boolean active;
    private final MenuItem<T> item;
    private final T value;

    public MenuState(MenuItem<T> item, boolean changed, boolean active, T value) {
        this.changed = changed;
        this.active = active;
        this.value = value;
        this.item = item;
    }

    public MenuItem<T> getItem() {
        return this.item;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isActive() {
        return this.active;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuState menuState = (MenuState)o;
        return this.isChanged() == menuState.isChanged() && this.isActive() == menuState.isActive() && Objects.equals(this.getValue(), menuState.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.isChanged(), this.isActive(), this.getValue());
    }
}

