/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.util;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.domain.util.AbstractMenuItemVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MenuItemHelper {
    public static <T> Optional<T> visitWithResult(MenuItem item, AbstractMenuItemVisitor<T> visitor) {
        item.accept(visitor);
        return visitor.getResult();
    }

    public static SubMenuItem asSubMenu(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<SubMenuItem>(){

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(item);
            }

            @Override
            public void anyItem(MenuItem item) {
            }
        }).orElse(null);
    }

    public static boolean isRuntimeStructureNeeded(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Boolean>(){

            @Override
            public void visit(RuntimeListMenuItem listItem) {
                this.setResult(true);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(false);
            }
        }).orElse(false);
    }

    public static MenuItem createFromExistingWithId(MenuItem selected, final int newId) {
        return MenuItemHelper.visitWithResult(selected, new AbstractMenuItemVisitor<MenuItem>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(((AnalogMenuItemBuilder)AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(((EnumMenuItemBuilder)EnumMenuItemBuilder.anEnumMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(((SubMenuItemBuilder)SubMenuItemBuilder.aSubMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(((EditableTextMenuItemBuilder)EditableTextMenuItemBuilder.aTextMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(FloatMenuItem item) {
                this.setResult(((FloatMenuItemBuilder)FloatMenuItemBuilder.aFloatMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(ActionMenuItem item) {
                this.setResult(((ActionMenuItemBuilder)ActionMenuItemBuilder.anActionMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(RuntimeListMenuItem item) {
                this.setResult(((RuntimeListMenuItemBuilder)RuntimeListMenuItemBuilder.aRuntimeListMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }
        }).orElse(null);
    }

    public static int eepromSizeForItem(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Integer>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(1);
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                if (item.getItemType() == EditItemType.IP_ADDRESS) {
                    this.setResult(4);
                } else {
                    this.setResult(item.getTextLength());
                }
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(0);
            }
        }).orElse(0);
    }

    public static String makeNameToVar(String name) {
        List<String> parts = Arrays.asList(name.split("[\\p{P}\\p{Z}\\t\\r\\n\\v\\f^]+"));
        return parts.stream().map(MenuItemHelper::capitaliseFirst).collect(Collectors.joining());
    }

    private static String capitaliseFirst(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

