/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteControllerListener;
import com.thecoderscorner.menu.remote.RemoteInformation;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteMenuController {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final RemoteConnector connector;
    private final MenuTree managedMenu;
    private final ScheduledExecutorService executor;
    private final Clock clock;
    private final AtomicLong lastRx = new AtomicLong();
    private final AtomicLong lastTx = new AtomicLong();
    private final AtomicReference<RemoteInformation> remoteParty = new AtomicReference<RemoteInformation>(RemoteInformation.NOT_CONNECTED);
    private final String localName;
    private final UUID ourUUID;
    private final ConcurrentMap<CorrelationId, MenuItem> itemsInProgress = new ConcurrentHashMap<CorrelationId, MenuItem>();
    private final List<RemoteControllerListener> listeners = new CopyOnWriteArrayList<RemoteControllerListener>();
    private volatile boolean treeFullyPopulated = false;
    private volatile int heartbeatFrequency = 10000;
    private AtomicReference<AuthStatus> authenticatedState = new AtomicReference<AuthStatus>(AuthStatus.AWAITING_CONNECTION);

    public RemoteMenuController(RemoteConnector connector, MenuTree managedMenu, ScheduledExecutorService executor, String localName, UUID ourUUID, Clock clock) {
        this.connector = connector;
        this.managedMenu = managedMenu;
        this.executor = executor;
        this.ourUUID = ourUUID;
        this.clock = clock;
        this.localName = localName;
    }

    public void start() {
        this.connector.registerConnectorListener(this::onCommandReceived);
        this.connector.registerConnectionChangeListener(this::onConnectionChange);
        this.setConnectionState(AuthStatus.AWAITING_CONNECTION);
        this.connector.start();
        this.executor.scheduleAtFixedRate(this::checkHeartbeat, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void checkHeartbeat() {
        if (!this.connector.isConnected()) {
            return;
        }
        if (this.clock.millis() - this.lastRx.get() > (long)(3 * this.heartbeatFrequency)) {
            this.logger.log(System.Logger.Level.WARNING, "Lost connection with " + this.getConnector().getConnectionName() + ", closing port");
            this.connector.close();
        }
        if (this.clock.millis() - this.lastTx.get() > (long)this.heartbeatFrequency) {
            this.logger.log(System.Logger.Level.INFO, "Sending heartbeat to " + this.getConnector().getConnectionName() + " port");
            this.sendCommand(CommandFactory.newHeartbeatCommand(this.heartbeatFrequency));
        }
    }

    private void onConnectionChange(RemoteConnector remoteConnector, boolean b) {
        if (b) {
            this.lastRx.set(this.clock.millis());
            this.setConnectionState(AuthStatus.AWAITING_JOIN);
        } else {
            this.setConnectionState(AuthStatus.AWAITING_CONNECTION);
            this.itemsInProgress.forEach((key, item) -> this.listeners.forEach(rcl -> rcl.ackReceived((CorrelationId)key, (MenuItem)item, AckStatus.UNKNOWN_ERROR)));
            this.itemsInProgress.clear();
        }
    }

    public void stop() {
        this.connector.stop();
    }

    protected void sendCommand(MenuCommand command) {
        this.lastTx.set(this.clock.millis());
        try {
            this.connector.sendMenuCommand(command);
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Error while writing out command", (Throwable)e);
            this.connector.close();
        }
    }

    public CorrelationId sendDialogAction(MenuButtonType buttonType) {
        CorrelationId correlationId = new CorrelationId();
        this.sendCommand(CommandFactory.newDialogCommand(DialogMode.ACTION, "", "", buttonType, buttonType, correlationId));
        return correlationId;
    }

    public CorrelationId sendDeltaUpdate(MenuItem item, int deltaChange) {
        CorrelationId correlationId = new CorrelationId();
        this.itemsInProgress.put(correlationId, item);
        this.sendCommand(CommandFactory.newDeltaChangeCommand(correlationId, item, deltaChange));
        return correlationId;
    }

    public CorrelationId sendAbsoluteUpdate(MenuItem item, Object newValue) {
        CorrelationId correlationId = new CorrelationId();
        this.itemsInProgress.put(correlationId, item);
        this.sendCommand(CommandFactory.newAbsoluteMenuChangeCommand(correlationId, item, newValue));
        return correlationId;
    }

    public RemoteInformation getRemotePartyInfo() {
        return this.remoteParty.get();
    }

    public RemoteConnector getConnector() {
        return this.connector;
    }

    public boolean isTreeFullyPopulated() {
        return this.treeFullyPopulated;
    }

    public void addListener(RemoteControllerListener listener) {
        this.listeners.add(listener);
    }

    private void onCommandReceived(RemoteConnector remoteConnector, MenuCommand menuCommand) {
        this.lastRx.set(this.clock.millis());
        switch (menuCommand.getCommandType()) {
            case HEARTBEAT: {
                this.onHeartbeat((MenuHeartbeatCommand)menuCommand);
                break;
            }
            case JOIN: {
                this.onJoinCommand((MenuJoinCommand)menuCommand);
                break;
            }
            case BOOTSTRAP: {
                this.onBootstrapCommand((MenuBootstrapCommand)menuCommand);
                break;
            }
            case ACKNOWLEDGEMENT: {
                this.onAcknowledgementCommand((MenuAcknowledgementCommand)menuCommand);
                break;
            }
            case PAIRING_REQUEST: {
                break;
            }
            case ANALOG_BOOT_ITEM: 
            case ENUM_BOOT_ITEM: 
            case BOOLEAN_BOOT_ITEM: 
            case SUBMENU_BOOT_ITEM: 
            case TEXT_BOOT_ITEM: 
            case REMOTE_BOOT_ITEM: 
            case FLOAT_BOOT_ITEM: 
            case ACTION_BOOT_ITEM: 
            case RUNTIME_LIST_BOOT: {
                this.onMenuItemBoot((BootItemMenuCommand)menuCommand);
                break;
            }
            case CHANGE_INT_FIELD: {
                this.onChangeField((MenuChangeCommand)menuCommand);
                break;
            }
            case DIALOG_UPDATE: {
                this.onDialogChange((MenuDialogCommand)menuCommand);
            }
        }
    }

    private void onDialogChange(MenuDialogCommand menuCommand) {
        this.listeners.forEach(l -> l.dialogUpdate(menuCommand.getDialogMode(), menuCommand.getHeader(), menuCommand.getBuffer(), menuCommand.getButton1(), menuCommand.getButton2()));
    }

    private void onAcknowledgementCommand(MenuAcknowledgementCommand menuCommand) {
        if (this.authenticatedState.get() == AuthStatus.SENT_JOIN && menuCommand.getCorrelationId().getUnderlyingId() == 0L) {
            if (menuCommand.getAckStatus().isError()) {
                this.logger.log(System.Logger.Level.ERROR, "Disconnected due to failed authentication");
                this.setConnectionState(AuthStatus.FAILED_AUTH);
                this.connector.close();
            } else {
                this.logger.log(System.Logger.Level.INFO, "Connected and authenticated.");
                this.setConnectionState(AuthStatus.AUTHENTICATED);
            }
        } else {
            MenuItem item = (MenuItem)this.itemsInProgress.get(menuCommand.getCorrelationId());
            this.listeners.forEach(rcl -> rcl.ackReceived(menuCommand.getCorrelationId(), item, menuCommand.getAckStatus()));
        }
    }

    private void setConnectionState(AuthStatus authStatus) {
        this.authenticatedState.set(authStatus);
        this.listeners.forEach(l -> l.connectionState(this.getRemotePartyInfo(), authStatus));
    }

    private void onHeartbeat(MenuHeartbeatCommand hbCommand) {
        if (this.heartbeatFrequency != hbCommand.getHearbeatInterval()) {
            this.logger.log(System.Logger.Level.INFO, "Heartbeat interval is now " + hbCommand.getHearbeatInterval());
            this.heartbeatFrequency = hbCommand.getHearbeatInterval();
        }
    }

    private void onMenuItemBoot(BootItemMenuCommand menuCommand) {
        this.managedMenu.addOrUpdateItem(menuCommand.getSubMenuId(), (MenuItem)menuCommand.getMenuItem());
        this.managedMenu.changeItem(menuCommand.getMenuItem(), menuCommand.newMenuState(this.managedMenu.getMenuState(menuCommand.getMenuItem())));
        this.listeners.forEach(l -> l.menuItemChanged((MenuItem)menuCommand.getMenuItem(), false));
    }

    private void onChangeField(final MenuChangeCommand menuCommand) {
        if (!this.treeFullyPopulated) {
            return;
        }
        this.managedMenu.getMenuById(menuCommand.getMenuItemId()).ifPresent(item -> item.accept(new MenuItemVisitor(){

            @Override
            public void visit(AnalogMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Integer.valueOf(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(BooleanMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Integer.valueOf(menuCommand.getValue()) != 0, true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(EnumMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Integer.valueOf(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(SubMenuItem item) {
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(menuCommand.getValue(), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(FloatMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Float.valueOf(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(ActionMenuItem item) {
            }

            @Override
            public void visit(RuntimeListMenuItem listItem) {
            }
        }));
    }

    private void onBootstrapCommand(MenuBootstrapCommand cmd) {
        boolean bl = this.treeFullyPopulated = cmd.getBootType() == MenuBootstrapCommand.BootType.END;
        if (this.treeFullyPopulated) {
            this.listeners.forEach(RemoteControllerListener::treeFullyPopulated);
        }
    }

    private void onJoinCommand(MenuJoinCommand join) {
        this.remoteParty.set(new RemoteInformation(join.getMyName(), join.getApiVersion() / 100, join.getApiVersion() % 100, join.getPlatform()));
        this.setConnectionState(AuthStatus.SENT_JOIN);
        this.sendCommand(CommandFactory.newJoinCommand(this.localName, this.ourUUID));
    }

    public MenuTree getManagedMenu() {
        return this.managedMenu;
    }
}

