/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MenuChangeCommand
implements MenuCommand {
    private final int menuItemId;
    private final CorrelationId correlationId;
    private final ChangeType changeType;
    private final String value;
    private final List<String> values;

    public MenuChangeCommand(CorrelationId correlationId, int itemId, ChangeType changeType, String value) {
        this.correlationId = correlationId;
        this.menuItemId = itemId;
        this.value = value;
        this.changeType = changeType;
        this.values = null;
    }

    public MenuChangeCommand(CorrelationId correlation, int itemId, List<String> values) {
        this.correlationId = correlation;
        this.menuItemId = itemId;
        this.value = null;
        this.values = new ArrayList<String>(values);
        this.changeType = ChangeType.ABSOLUTE_LIST;
    }

    @Override
    public MenuCommandType getCommandType() {
        return MenuCommandType.CHANGE_INT_FIELD;
    }

    public int getMenuItemId() {
        return this.menuItemId;
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public static int changeTypeToInt(ChangeType changeType) {
        if (changeType == ChangeType.DELTA) {
            return 0;
        }
        if (changeType == ChangeType.ABSOLUTE) {
            return 1;
        }
        return 2;
    }

    public static ChangeType changeTypeFromInt(int changeType) {
        switch (changeType) {
            case 1: {
                return ChangeType.ABSOLUTE;
            }
            case 2: {
                return ChangeType.ABSOLUTE_LIST;
            }
        }
        return ChangeType.DELTA;
    }

    public String toString() {
        return "MenuChangeCommand{menuItemId=" + this.menuItemId + ", correlation=" + this.correlationId + ", changeType=" + this.changeType + ", value='" + this.value + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuChangeCommand that = (MenuChangeCommand)o;
        return this.getMenuItemId() == that.getMenuItemId() && this.getCorrelationId() == that.getCorrelationId() && this.getChangeType() == that.getChangeType() && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMenuItemId(), this.getCorrelationId(), this.getChangeType(), this.getValue()});
    }

    public static enum ChangeType {
        ABSOLUTE,
        ABSOLUTE_LIST,
        DELTA;

    }
}

