/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class PairingHelper {
    private final System.Logger logger = System.getLogger("Pairing");
    private final RemoteConnector connector;
    private final ScheduledExecutorService executorService;
    private final Optional<Consumer<PairingState>> statusConsumer;
    private final AtomicReference<PairingState> pairingState = new AtomicReference<PairingState>(PairingState.DISCONNECTED);

    public PairingHelper(RemoteConnector connector, ScheduledExecutorService executorService, Optional<Consumer<PairingState>> updateFn) {
        this.connector = connector;
        this.executorService = executorService;
        this.statusConsumer = updateFn;
    }

    public boolean attemptPairing(String name, UUID uuid) {
        this.setPairingState(PairingState.DISCONNECTED);
        this.logger.log(System.Logger.Level.INFO, "Pairing process started for " + name);
        CountDownLatch latch = new CountDownLatch(1);
        this.connector.registerConnectionChangeListener((connector1, connected) -> {
            if (connected) {
                this.executorService.execute(() -> {
                    try {
                        this.logger.log(System.Logger.Level.INFO, "Connected, sending pair request" + name);
                        this.connector.sendMenuCommand(CommandFactory.newPairingCommand(name, uuid));
                    }
                    catch (IOException e) {
                        this.logger.log(System.Logger.Level.ERROR, "Failed to send pair request to " + name);
                    }
                });
                this.setPairingState(PairingState.PAIRING_SENT);
            }
        });
        this.connector.registerConnectorListener((connector12, command) -> {
            if (command.getCommandType() == MenuCommandType.ACKNOWLEDGEMENT) {
                MenuAcknowledgementCommand ack = (MenuAcknowledgementCommand)command;
                this.logger.log(System.Logger.Level.INFO, "Received ACK for request " + name + " - " + ack.getAckStatus());
                this.setPairingState(ack.getAckStatus().isError() ? PairingState.NOT_ACCEPTED : PairingState.ACCEPTED);
                latch.countDown();
            }
        });
        this.connector.start();
        try {
            if (!latch.await(20L, TimeUnit.SECONDS)) {
                this.logger.log(System.Logger.Level.INFO, "Timeout pairing with " + name);
                this.setPairingState(PairingState.TIMED_OUT);
            }
        }
        catch (InterruptedException e) {
            this.logger.log(System.Logger.Level.ERROR, "Pairing thread interrupted: " + name);
            Thread.currentThread().interrupt();
            this.setPairingState(PairingState.TIMED_OUT);
        }
        this.connector.close();
        this.connector.stop();
        this.logger.log(System.Logger.Level.INFO, "Pairing finished for " + name + " - " + (Object)((Object)this.pairingState.get()));
        return this.pairingState.get() == PairingState.ACCEPTED;
    }

    private void setPairingState(PairingState s) {
        this.pairingState.set(s);
        this.statusConsumer.ifPresent(pairingStateConsumer -> pairingStateConsumer.accept(s));
    }

    public static enum PairingState {
        DISCONNECTED,
        PAIRING_SENT,
        NOT_ACCEPTED,
        ACCEPTED,
        TIMED_OUT;

    }
}

