/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.BooleanMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class SubMenuItem
extends MenuItem<Boolean> {
    private final boolean secured;

    public SubMenuItem() {
        super("", -1, -1, null, false, false);
        this.secured = false;
    }

    public SubMenuItem(String name, int id, int eepromAddr, boolean localOnly, boolean secured) {
        super(name, id, eepromAddr, null, false, localOnly);
        this.secured = secured;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public boolean isSecured() {
        return this.secured;
    }

    @Override
    public MenuState<Boolean> newMenuState(Boolean value, boolean changed, boolean active) {
        return new BooleanMenuState(this, changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubMenuItem that = (SubMenuItem)o;
        return this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isSecured() == that.isSecured() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly(), this.isSecured());
    }
}

