/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.states.BaseMessageProcessingState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import java.io.IOException;

public class SendPairingMessageState
extends BaseMessageProcessingState {
    public SendPairingMessageState(RemoteConnectorContext context) {
        super(context);
    }

    @Override
    public void enterState() {
        super.enterState();
        try {
            this.context.sendPairing();
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Unable to send pairing request", (Throwable)e);
            this.markDone();
            this.context.close();
            this.context.changeState(AuthStatus.AWAITING_CONNECTION);
        }
    }

    @Override
    protected void processTimeout() {
        this.logger.log(System.Logger.Level.ERROR, "Timeout while pairing");
        this.markDone();
        this.context.close();
        this.context.changeState(AuthStatus.AWAITING_CONNECTION);
    }

    @Override
    protected boolean processMessage(MenuCommand cmd) {
        if (this.checkIfThereIsAnHbEnd(cmd)) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.HEARTBEAT || cmd.getCommandType() == MenuCommandType.JOIN) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.ACKNOWLEDGEMENT) {
            MenuAcknowledgementCommand ack = (MenuAcknowledgementCommand)cmd;
            this.markDone();
            this.context.changeState(ack.getAckStatus() == AckStatus.SUCCESS ? AuthStatus.AUTHENTICATED : AuthStatus.FAILED_AUTH);
            return true;
        }
        return false;
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.SEND_AUTH;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return command.getCommandType() == MenuCommandType.HEARTBEAT || command.getCommandType() == MenuCommandType.PAIRING_REQUEST;
    }
}

