/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EnumMenuItem
extends MenuItem<Integer> {
    private final List<String> enumEntries;

    public EnumMenuItem() {
        super("", -1, -1, null, false);
        this.enumEntries = Collections.emptyList();
    }

    public EnumMenuItem(String name, int id, int eepromAddress, String functionName, List<String> enumEntries, boolean readOnly) {
        super(name, id, eepromAddress, functionName, readOnly);
        this.enumEntries = enumEntries;
    }

    public List<String> getEnumEntries() {
        return this.enumEntries;
    }

    @Override
    public MenuState<Integer> newMenuState(Integer value, boolean changed, boolean active) {
        return new IntegerMenuState(changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumMenuItem that = (EnumMenuItem)o;
        return this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getEnumEntries(), that.getEnumEntries()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.getEnumEntries(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly());
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

