/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.rs232;

import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.NamedDaemonThreadFactory;
import com.thecoderscorner.menu.remote.RemoteMenuController;
import com.thecoderscorner.menu.remote.protocol.TagValMenuCommandProtocol;
import com.thecoderscorner.menu.remote.rs232.Rs232RemoteConnector;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class Rs232ControllerBuilder {
    private String portName;
    private int baud;
    private ScheduledExecutorService executorService;
    private MenuTree menuTree;
    private MenuCommandProtocol protocol;
    private Clock clock = Clock.systemDefaultZone();
    private String name = "NoName";

    public Rs232ControllerBuilder withRs232(String port, int baud) {
        this.portName = port;
        this.baud = baud;
        return this;
    }

    public Rs232ControllerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public Rs232ControllerBuilder withExecutor(ScheduledExecutorService executor) {
        this.executorService = executor;
        return this;
    }

    public Rs232ControllerBuilder withMenuTree(MenuTree tree) {
        this.menuTree = tree;
        return this;
    }

    public Rs232ControllerBuilder withProtocol(MenuCommandProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Rs232ControllerBuilder withLocalName(String name) {
        this.name = name;
        return this;
    }

    public RemoteMenuController build() {
        if (this.protocol == null) {
            this.protocol = new TagValMenuCommandProtocol();
        }
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2, new NamedDaemonThreadFactory("rs232-remote"));
        }
        Rs232RemoteConnector connector = new Rs232RemoteConnector(this.portName, this.baud, this.protocol, this.executorService);
        return new RemoteMenuController(connector, this.menuTree, this.executorService, this.name, this.clock);
    }
}

