/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.socket;

import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class SocketBasedConnector
extends StreamRemoteConnector {
    private final String remoteHost;
    private final int remotePort;
    private final AtomicReference<SocketChannel> socketChannel = new AtomicReference();

    public SocketBasedConnector(ScheduledExecutorService executor, MenuCommandProtocol protocol, String remoteHost, int remotePort) {
        super(protocol, executor);
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    @Override
    public void start() {
        this.executor.execute(this::threadReadLoop);
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }

    private void threadReadLoop() {
        this.logger.log(System.Logger.Level.INFO, "Starting socket read loop for " + this.remoteHost + ":" + this.remotePort);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.attemptToConnect()) {
                    this.processMessagesOnConnection();
                    continue;
                }
                this.sleepResettingInterrupt();
            }
            catch (Exception ex) {
                this.logger.log(System.Logger.Level.ERROR, "Exception on socket " + this.remoteHost + ":" + this.remotePort, (Throwable)ex);
                this.close();
                this.sleepResettingInterrupt();
            }
        }
        this.close();
        this.logger.log(System.Logger.Level.INFO, "Exiting socket read loop for " + this.remoteHost + ":" + this.remotePort);
    }

    private void sleepResettingInterrupt() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            this.logger.log(System.Logger.Level.INFO, "Thread has been interrupted");
            Thread.currentThread().interrupt();
        }
    }

    private boolean attemptToConnect() throws IOException {
        if (this.socketChannel.get() == null || !this.socketChannel.get().isConnected()) {
            this.close();
            SocketChannel ch = SocketChannel.open();
            ch.socket().connect(new InetSocketAddress(this.remoteHost, this.remotePort), 10000);
            this.socketChannel.set(ch);
        }
        return true;
    }

    @Override
    protected void getAtLeastBytes(ByteBuffer inputBuffer, int len, StreamRemoteConnector.ReadMode mode) throws IOException {
        if (mode == StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY && inputBuffer.remaining() >= len) {
            return;
        }
        SocketChannel sc = this.socketChannel.get();
        if (sc == null || !this.isConnected()) {
            throw new IOException("Socket closed during read");
        }
        do {
            inputBuffer.compact();
            int actual = sc.read(inputBuffer);
            inputBuffer.flip();
            if (actual > 0) continue;
            throw new IOException("Socket probably closed, read return was 0 or less");
        } while (inputBuffer.remaining() < len);
    }

    @Override
    protected void sendInternal(ByteBuffer outputBuffer) throws IOException {
        SocketChannel sc = this.socketChannel.get();
        while (this.isConnected() && sc != null && outputBuffer.hasRemaining()) {
            int len = sc.write(outputBuffer);
            if (len > 0) continue;
            throw new IOException("Socket closed - returned 0 or less from write");
        }
    }

    @Override
    public String getConnectionName() {
        return "TCP " + this.remoteHost + ":" + this.remotePort;
    }

    @Override
    public void close() {
        if (this.socketChannel.get() == null) {
            return;
        }
        try {
            this.socketChannel.get().close();
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Unexpected error closing socket", (Throwable)e);
        }
        super.close();
        this.socketChannel.set(null);
    }
}

