/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuActionBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuAnalogBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBooleanBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.commands.MenuEnumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuFloatBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuLargeNumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuPairingCommand;
import com.thecoderscorner.menu.remote.commands.MenuRuntimeListBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuSubBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuTextBootCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.ProtocolUtil;
import com.thecoderscorner.menu.remote.protocol.TagValTextParser;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class TagValMenuCommandProtocol
implements MenuCommandProtocol {
    public static final byte PROTOCOL_TAG_VAL = 1;
    public static final byte START_OF_MSG = 1;
    public static final byte END_OF_MSG = 2;
    public static final byte FIELD_TERMINATOR = 124;
    private static final boolean DEBUG_ALL_MESSAGES = false;
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final Map<String, MenuCommandType> codeToCmdType = new HashMap<String, MenuCommandType>();

    public TagValMenuCommandProtocol() {
        for (MenuCommandType ty : MenuCommandType.values()) {
            this.codeToCmdType.put(ty.getCode(), ty);
        }
    }

    @Override
    public MenuCommand fromChannel(ByteBuffer buffer) throws IOException {
        String ty = this.getMsgTypeFromBuffer(buffer);
        TagValTextParser parser = new TagValTextParser(buffer);
        MenuCommandType cmdType = this.codeToCmdType.get(ty);
        if (cmdType == null) {
            throw new TcProtocolException("Protocol received unexpected message: " + ty);
        }
        switch (cmdType) {
            case JOIN: {
                return this.processJoin(parser);
            }
            case HEARTBEAT: {
                return this.processHeartbeat(parser);
            }
            case BOOTSTRAP: {
                return this.processBootstrap(parser);
            }
            case ANALOG_BOOT_ITEM: {
                return this.processAnalogBootItem(parser);
            }
            case SUBMENU_BOOT_ITEM: {
                return this.processSubMenuBootItem(parser);
            }
            case ENUM_BOOT_ITEM: {
                return this.processEnumBootItem(parser);
            }
            case BOOLEAN_BOOT_ITEM: {
                return this.processBoolBootItem(parser);
            }
            case LARGE_NUM_BOOT_ITEM: {
                return this.processLargeNumBootItem(parser);
            }
            case CHANGE_INT_FIELD: {
                return this.processItemChange(parser);
            }
            case TEXT_BOOT_ITEM: {
                return this.processTextItem(parser);
            }
            case FLOAT_BOOT_ITEM: {
                return this.processFloatItem(parser);
            }
            case ACTION_BOOT_ITEM: {
                return this.processActionItem(parser);
            }
            case RUNTIME_LIST_BOOT: {
                return this.processRuntimeListBoot(parser);
            }
            case ACKNOWLEDGEMENT: {
                return this.processAcknowledgement(parser);
            }
            case PAIRING_REQUEST: {
                return this.processPairingRequest(parser);
            }
            case DIALOG_UPDATE: {
                return this.processDialogUpdate(parser);
            }
        }
        throw new TcProtocolException("Unknown message type " + cmdType);
    }

    private String getMsgTypeFromBuffer(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder();
        return sb.append((char)buffer.get()).append((char)buffer.get()).toString();
    }

    private MenuCommand processDialogUpdate(TagValTextParser parser) throws IOException {
        String cor = parser.getValueWithDefault("IC", "");
        CorrelationId correlationId = cor.isEmpty() ? CorrelationId.EMPTY_CORRELATION : new CorrelationId(cor);
        return CommandFactory.newDialogCommand(this.asDialogMode(parser.getValue("MO")), parser.getValueWithDefault("HF", ""), parser.getValueWithDefault("BU", ""), this.asButton(parser.getValueAsIntWithDefault("B1", 0)), this.asButton(parser.getValueAsIntWithDefault("B2", 0)), correlationId);
    }

    private DialogMode asDialogMode(String mode) {
        if (mode.equals("S")) {
            return DialogMode.SHOW;
        }
        if (mode.equals("H")) {
            return DialogMode.HIDE;
        }
        return DialogMode.ACTION;
    }

    private MenuButtonType asButton(int req) {
        return Arrays.stream(MenuButtonType.values()).filter(b -> b.getTypeVal() == req).findFirst().orElse(MenuButtonType.NONE);
    }

    private MenuCommand processPairingRequest(TagValTextParser parser) throws IOException {
        return CommandFactory.newPairingCommand(parser.getValue("NM"), UUID.fromString(parser.getValue("UU")));
    }

    private MenuCommand processAcknowledgement(TagValTextParser parser) throws IOException {
        CorrelationId id = new CorrelationId(parser.getValueWithDefault("IC", "0"));
        return CommandFactory.newAcknowledgementCommand(id, this.fromCode(parser.getValueAsInt("ST")));
    }

    private AckStatus fromCode(int codeIn) {
        return Arrays.stream(AckStatus.values()).filter(s -> s.getStatusCode() == codeIn).findFirst().orElse(AckStatus.UNKNOWN_ERROR);
    }

    private MenuCommand processItemChange(TagValTextParser parser) throws IOException {
        CorrelationId correlation;
        MenuChangeCommand.ChangeType type = MenuChangeCommand.changeTypeFromInt(parser.getValueAsInt("TC"));
        String corStr = parser.getValueWithDefault("IC", "");
        CorrelationId correlationId = correlation = corStr.isEmpty() ? CorrelationId.EMPTY_CORRELATION : new CorrelationId(corStr);
        if (type == MenuChangeCommand.ChangeType.DELTA) {
            return CommandFactory.newDeltaChangeCommand(correlation, parser.getValueAsInt("ID"), parser.getValueAsInt("VC"));
        }
        if (type == MenuChangeCommand.ChangeType.ABSOLUTE) {
            return CommandFactory.newAbsoluteMenuChangeCommand(correlation, parser.getValueAsInt("ID"), (Object)parser.getValue("VC"));
        }
        List<String> choices = this.choicesFromMsg(parser);
        return CommandFactory.newAbsoluteListChangeCommand(correlation, parser.getValueAsInt("ID"), choices);
    }

    private MenuCommand processRuntimeListBoot(TagValTextParser parser) throws IOException {
        RuntimeListMenuItem item = ((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)RuntimeListMenuItemBuilder.aRuntimeListMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withInitialRows(parser.getValueAsInt("NC")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        List<String> choices = this.choicesFromMsg(parser);
        return CommandFactory.newRuntimeListBootCommand(parentId, item, choices);
    }

    private MenuCommand processBoolBootItem(TagValTextParser parser) throws IOException {
        BooleanMenuItem item = ((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withNaming(this.toNaming(parser.getValueAsInt("BN"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newMenuBooleanBootCommand(parentId, item, currentVal != 0);
    }

    private MenuCommand processLargeNumBootItem(TagValTextParser parser) throws IOException {
        EditableLargeNumberMenuItem item = ((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)EditableLargeNumberMenuItemBuilder.aLargeNumberItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withDecimalPlaces(parser.getValueAsInt("FD")).withTotalDigits(parser.getValueAsInt("ML")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String text = parser.getValue("VC").replaceAll("[\\[\\]]", "");
        return CommandFactory.newLargeNumberBootItem(parentId, item, new BigDecimal(text));
    }

    private MenuCommand processTextItem(TagValTextParser parser) throws IOException {
        EditableTextMenuItem item = ((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)EditableTextMenuItemBuilder.aTextMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withEditItemType(EditItemType.fromId(parser.getValueAsInt("EM"))).withLength(parser.getValueAsInt("ML")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuTextBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processFloatItem(TagValTextParser parser) throws IOException {
        FloatMenuItem item = ((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)FloatMenuItemBuilder.aFloatMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withDecimalPlaces(parser.getValueAsInt("FD")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuFloatBootCommand(parentId, item, Float.valueOf(currentVal));
    }

    private BooleanMenuItem.BooleanNaming toNaming(int i) {
        if (i == 0) {
            return BooleanMenuItem.BooleanNaming.TRUE_FALSE;
        }
        if (i == 1) {
            return BooleanMenuItem.BooleanNaming.ON_OFF;
        }
        return BooleanMenuItem.BooleanNaming.YES_NO;
    }

    private MenuCommand processEnumBootItem(TagValTextParser parser) throws IOException {
        List<String> choices = this.choicesFromMsg(parser);
        EnumMenuItem item = ((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)EnumMenuItemBuilder.anEnumMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withEnumList(choices).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newMenuEnumBootCommand(parentId, item, currentVal);
    }

    private List<String> choicesFromMsg(TagValTextParser parser) throws IOException {
        ArrayList<String> choices = new ArrayList<String>();
        int noOfItems = parser.getValueAsInt("NC");
        for (int i = 0; i < noOfItems; ++i) {
            String keyVal = "C" + (char)(i + 65);
            String keyName = "c" + (char)(i + 65);
            String keyText = parser.getValueWithDefault(keyName, "");
            String valText = parser.getValueWithDefault(keyVal, "");
            if (keyText.isEmpty()) {
                choices.add(valText);
                continue;
            }
            choices.add(keyText + "\t" + valText);
        }
        return choices;
    }

    private MenuCommand processSubMenuBootItem(TagValTextParser parser) throws IOException {
        SubMenuItem item = ((SubMenuItemBuilder)((SubMenuItemBuilder)((SubMenuItemBuilder)SubMenuItemBuilder.aSubMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        return CommandFactory.newMenuSubBootCommand(parentId, item);
    }

    private MenuCommand processActionItem(TagValTextParser parser) throws IOException {
        ActionMenuItem item = ((ActionMenuItemBuilder)((ActionMenuItemBuilder)((ActionMenuItemBuilder)ActionMenuItemBuilder.anActionMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        return new MenuActionBootCommand(parentId, item, Boolean.FALSE);
    }

    private MenuCommand processAnalogBootItem(TagValTextParser parser) throws IOException {
        AnalogMenuItem item = ((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withDivisor(parser.getValueAsInt("AD")).withMaxValue(parser.getValueAsInt("AM")).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withOffset(parser.getValueAsInt("AO")).withUnit(parser.getValue("AU")).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newAnalogBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processBootstrap(TagValTextParser parser) throws IOException {
        MenuBootstrapCommand.BootType bt = MenuBootstrapCommand.BootType.valueOf(parser.getValue("BT"));
        return new MenuBootstrapCommand(bt);
    }

    private MenuCommand processJoin(TagValTextParser parser) throws IOException {
        String uuidStr = parser.getValueWithDefault("UU", "");
        UUID uuid = uuidStr.isEmpty() ? UUID.randomUUID() : UUID.fromString(uuidStr);
        return new MenuJoinCommand(uuid, parser.getValue("NM"), ProtocolUtil.fromKeyToApiPlatform(parser.getValueAsInt("PF")), parser.getValueAsInt("VE"));
    }

    private MenuCommand processHeartbeat(TagValTextParser parser) throws IOException {
        return CommandFactory.newHeartbeatCommand(parser.getValueAsIntWithDefault("HI", 10000), this.toHbMode(parser.getValueAsIntWithDefault("HR", 0)));
    }

    private MenuHeartbeatCommand.HeartbeatMode toHbMode(int hbModeInt) {
        switch (hbModeInt) {
            case 1: {
                return MenuHeartbeatCommand.HeartbeatMode.START;
            }
            case 2: {
                return MenuHeartbeatCommand.HeartbeatMode.END;
            }
        }
        return MenuHeartbeatCommand.HeartbeatMode.NORMAL;
    }

    @Override
    public void toChannel(ByteBuffer buffer, MenuCommand cmd) {
        StringBuilder sb = new StringBuilder(128);
        switch (cmd.getCommandType()) {
            case HEARTBEAT: {
                this.writeHeartbeat(sb, (MenuHeartbeatCommand)cmd);
                break;
            }
            case JOIN: {
                this.writeJoin(sb, (MenuJoinCommand)cmd);
                break;
            }
            case BOOTSTRAP: {
                this.writeBootstrap(sb, (MenuBootstrapCommand)cmd);
                break;
            }
            case ANALOG_BOOT_ITEM: {
                this.writeAnalogItem(sb, (MenuAnalogBootCommand)cmd);
                break;
            }
            case SUBMENU_BOOT_ITEM: {
                this.writeSubMenuItem(sb, (MenuSubBootCommand)cmd);
                break;
            }
            case ENUM_BOOT_ITEM: {
                this.writeEnumMenuItem(sb, (MenuEnumBootCommand)cmd);
                break;
            }
            case ACTION_BOOT_ITEM: {
                this.writeActionBootItem(sb, (MenuActionBootCommand)cmd);
                break;
            }
            case FLOAT_BOOT_ITEM: {
                this.writeFloatBootItem(sb, (MenuFloatBootCommand)cmd);
                break;
            }
            case BOOLEAN_BOOT_ITEM: {
                this.writeBoolMenuItem(sb, (MenuBooleanBootCommand)cmd);
                break;
            }
            case RUNTIME_LIST_BOOT: {
                this.writeRuntimeListBootItem(sb, (MenuRuntimeListBootCommand)cmd);
                break;
            }
            case LARGE_NUM_BOOT_ITEM: {
                this.writeLargeNumberBootItem(sb, (MenuLargeNumBootCommand)cmd);
                break;
            }
            case CHANGE_INT_FIELD: {
                this.writeChangeInt(sb, (MenuChangeCommand)cmd);
                break;
            }
            case TEXT_BOOT_ITEM: {
                this.writeTextMenuItem(sb, (MenuTextBootCommand)cmd);
                break;
            }
            case ACKNOWLEDGEMENT: {
                this.writeAcknowledgement(sb, (MenuAcknowledgementCommand)cmd);
                break;
            }
            case PAIRING_REQUEST: {
                this.writePairingRequest(sb, (MenuPairingCommand)cmd);
                break;
            }
            case DIALOG_UPDATE: {
                this.writeDialogUpdate(sb, (MenuDialogCommand)cmd);
            }
        }
        sb.append('\u0002');
        String msgStr = sb.toString();
        buffer.put(msgStr.getBytes());
    }

    private void writeDialogUpdate(StringBuilder sb, MenuDialogCommand cmd) {
        this.appendField(sb, "MO", this.asWireMode(cmd.getDialogMode()));
        if (cmd.getHeader() != null) {
            this.appendField(sb, "HF", cmd.getHeader());
        }
        if (cmd.getBuffer() != null) {
            this.appendField(sb, "BU", cmd.getBuffer());
        }
        this.appendField(sb, "B1", cmd.getButton1().getTypeVal());
        this.appendField(sb, "B2", cmd.getButton2().getTypeVal());
        this.appendField(sb, "IC", cmd.getCorrelationId());
    }

    private String asWireMode(DialogMode dialogMode) {
        if (dialogMode == DialogMode.SHOW) {
            return "S";
        }
        if (dialogMode == DialogMode.HIDE) {
            return "H";
        }
        return "A";
    }

    private void writePairingRequest(StringBuilder sb, MenuPairingCommand cmd) {
        this.appendField(sb, "NM", cmd.getName());
        this.appendField(sb, "UU", cmd.getUuid());
    }

    private void writeAcknowledgement(StringBuilder sb, MenuAcknowledgementCommand cmd) {
        this.appendField(sb, "IC", cmd.getCorrelationId().toString());
        this.appendField(sb, "ST", cmd.getAckStatus().getStatusCode());
    }

    private void writeHeartbeat(StringBuilder sb, MenuHeartbeatCommand cmd) {
        int hbMode;
        switch (cmd.getMode()) {
            case START: {
                hbMode = 1;
                break;
            }
            case END: {
                hbMode = 2;
                break;
            }
            default: {
                hbMode = 0;
            }
        }
        this.appendField(sb, "HI", cmd.getHearbeatInterval());
        this.appendField(sb, "HR", hbMode);
    }

    @Override
    public byte getKeyIdentifier() {
        return 1;
    }

    private void writeChangeInt(StringBuilder sb, MenuChangeCommand cmd) {
        this.appendField(sb, "IC", cmd.getCorrelationId());
        this.appendField(sb, "ID", cmd.getMenuItemId());
        this.appendField(sb, "TC", MenuChangeCommand.changeTypeToInt(cmd.getChangeType()));
        if (cmd.getValues() != null) {
            this.appendChoices(sb, cmd.getValues());
        } else {
            this.appendField(sb, "VC", cmd.getValue());
        }
    }

    private void writeLargeNumberBootItem(StringBuilder sb, MenuLargeNumBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        int decimalPlaces = ((EditableLargeNumberMenuItem)cmd.getMenuItem()).getDecimalPlaces();
        this.appendField(sb, "FD", decimalPlaces);
        this.appendField(sb, "ML", ((EditableLargeNumberMenuItem)cmd.getMenuItem()).getDigitsAllowed());
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setGroupingUsed(false);
        fmt.setMinimumFractionDigits(decimalPlaces);
        fmt.setMaximumFractionDigits(decimalPlaces);
        this.appendField(sb, "VC", fmt.format(cmd.getCurrentValue()));
    }

    private void writeAnalogItem(StringBuilder sb, MenuAnalogBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "AO", ((AnalogMenuItem)cmd.getMenuItem()).getOffset());
        this.appendField(sb, "AD", ((AnalogMenuItem)cmd.getMenuItem()).getDivisor());
        this.appendField(sb, "AM", ((AnalogMenuItem)cmd.getMenuItem()).getMaxValue());
        this.appendField(sb, "AU", ((AnalogMenuItem)cmd.getMenuItem()).getUnitName());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeSubMenuItem(StringBuilder sb, MenuSubBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "VC", "0");
    }

    private void writeActionBootItem(StringBuilder sb, MenuActionBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "VC", "");
    }

    private void writeBoolMenuItem(StringBuilder sb, MenuBooleanBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "BN", this.fromNaming(((BooleanMenuItem)cmd.getMenuItem()).getNaming()));
        this.appendField(sb, "VC", (Boolean)cmd.getCurrentValue() != false ? 1 : 0);
    }

    private void writeCommonBootFields(StringBuilder sb, BootItemMenuCommand cmd) {
        this.appendField(sb, "PI", cmd.getSubMenuId());
        this.appendField(sb, "ID", ((MenuItem)cmd.getMenuItem()).getId());
        this.appendField(sb, "IE", ((MenuItem)cmd.getMenuItem()).getEepromAddress());
        this.appendField(sb, "NM", ((MenuItem)cmd.getMenuItem()).getName());
        this.appendField(sb, "RO", ((MenuItem)cmd.getMenuItem()).isReadOnly() ? 1 : 0);
        this.appendField(sb, "VI", ((MenuItem)cmd.getMenuItem()).isVisible() ? 1 : 0);
    }

    private void writeRuntimeListBootItem(StringBuilder sb, MenuRuntimeListBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendChoices(sb, (List)cmd.getCurrentValue());
    }

    private void writeFloatBootItem(StringBuilder sb, MenuFloatBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "FD", ((FloatMenuItem)cmd.getMenuItem()).getNumDecimalPlaces());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeTextMenuItem(StringBuilder sb, MenuTextBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "ML", ((EditableTextMenuItem)cmd.getMenuItem()).getTextLength());
        this.appendField(sb, "EM", ((EditableTextMenuItem)cmd.getMenuItem()).getItemType().getMsgId());
        this.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private int fromNaming(BooleanMenuItem.BooleanNaming naming) {
        switch (naming) {
            case ON_OFF: {
                return 1;
            }
            case YES_NO: {
                return 2;
            }
        }
        return 0;
    }

    private void writeEnumMenuItem(StringBuilder sb, MenuEnumBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendField(sb, "VC", cmd.getCurrentValue());
        List<String> entries = ((EnumMenuItem)cmd.getMenuItem()).getEnumEntries();
        this.appendChoices(sb, entries);
    }

    private void appendChoices(StringBuilder sb, List<String> entries) {
        this.appendField(sb, "NC", entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            this.appendField(sb, "C" + (char)(65 + i), entries.get(i));
        }
    }

    private void writeBootstrap(StringBuilder sb, MenuBootstrapCommand cmd) {
        this.appendField(sb, "BT", (Object)cmd.getBootType());
    }

    private void writeJoin(StringBuilder sb, MenuJoinCommand cmd) {
        this.appendField(sb, "NM", cmd.getMyName());
        this.appendField(sb, "UU", cmd.getAppUuid());
        this.appendField(sb, "VE", cmd.getApiVersion());
        this.appendField(sb, "PF", cmd.getPlatform().getKey());
    }

    private void appendField(StringBuilder sb, String key, Object value) {
        if (value instanceof String) {
            String val = (String)value;
            if (val.indexOf(124) != -1) {
                val = val.replace("|", "\\|");
            }
            if (val.indexOf(61) != -1) {
                val = val.replace("=", "\\=");
            }
            value = val;
        }
        sb.append(key);
        sb.append('=');
        sb.append(value);
        sb.append('|');
    }
}

