/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.rs232;

import com.fazecast.jSerialComm.SerialPort;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import com.thecoderscorner.menu.remote.states.NoOperationInitialState;
import com.thecoderscorner.menu.remote.states.SerialAwaitFirstMsgState;
import com.thecoderscorner.menu.remote.states.StreamNotConnectedState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;

public class Rs232RemoteConnector
extends StreamRemoteConnector {
    private final String portName;
    private final SerialPort serialPort;
    private final int baud;

    public Rs232RemoteConnector(LocalIdentifier localId, String portName, int baud, MenuCommandProtocol protocol, ScheduledExecutorService executor, Clock clock, ConnectMode connectMode) {
        super(localId, protocol, executor, clock);
        this.serialPort = SerialPort.getCommPort((String)portName);
        this.serialPort.setBaudRate(baud);
        this.portName = portName;
        this.baud = baud;
        this.applyStates(connectMode);
        this.logger.log(System.Logger.Level.INFO, "Created RS232 connector with port {0} and baud {1}.", portName, baud);
    }

    private void applyStates(ConnectMode connectMode) {
        this.stateMachineMappings.put(AuthStatus.NOT_STARTED, NoOperationInitialState.class);
        this.stateMachineMappings.put(AuthStatus.AWAITING_CONNECTION, StreamNotConnectedState.class);
        this.stateMachineMappings.put(AuthStatus.ESTABLISHED_CONNECTION, SerialAwaitFirstMsgState.class);
        this.stateMachineMappings.put(AuthStatus.FAILED_AUTH, SerialAwaitFirstMsgState.class);
        this.handleCoreConnectionStates(connectMode);
    }

    @Override
    public void start() {
        this.logger.log(System.Logger.Level.INFO, "Starting RS232 connector {0}", this.portName);
        this.changeState(new StreamNotConnectedState(this));
    }

    @Override
    public void stop() {
        this.changeState(AuthStatus.NOT_STARTED);
    }

    @Override
    public String getConnectionName() {
        return "Serial " + this.portName + "@" + this.baud;
    }

    @Override
    public boolean isDeviceConnected() {
        return this.serialPort.isOpen();
    }

    @Override
    public void performConnection() throws IOException {
        if (this.serialPort.isOpen()) {
            return;
        }
        if (!this.serialPort.openPort()) {
            throw new IOException("Serial port " + this.portName + " not opened.");
        }
    }

    @Override
    protected void sendInternal(ByteBuffer outputBuffer) throws IOException {
        byte[] data = new byte[outputBuffer.remaining()];
        outputBuffer.get(data, 0, data.length);
        this.serialPort.getOutputStream().write(data, 0, data.length);
        this.serialPort.getOutputStream().flush();
    }

    @Override
    protected void getAtLeastBytes(ByteBuffer inputBuffer, int len, StreamRemoteConnector.ReadMode mode) throws IOException {
        if (mode == StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY && inputBuffer.remaining() >= len) {
            return;
        }
        do {
            inputBuffer.compact();
            while (this.serialPort.bytesAvailable() > 0) {
                inputBuffer.put((byte)this.serialPort.getInputStream().read());
            }
            inputBuffer.flip();
        } while (inputBuffer.remaining() < len);
    }
}

