/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamNotConnectedState
implements RemoteConnectorState {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final RemoteConnectorContext context;
    private volatile Future connectionTask;
    private AtomicInteger connectionDelay = new AtomicInteger(2000);
    private final Object connectionWaiter = new Object();

    public StreamNotConnectedState(RemoteConnectorContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConnect() {
        try {
            this.logger.log(System.Logger.Level.INFO, "Attempting connection to " + this.context.getConnectionName());
            if (!this.context.isDeviceConnected()) {
                this.context.performConnection();
            }
            if (this.context.isDeviceConnected()) {
                this.logger.log(System.Logger.Level.INFO, "Connection established to " + this.context.getConnectionName());
                this.context.changeState(AuthStatus.ESTABLISHED_CONNECTION);
            }
        }
        catch (Exception e) {
            this.logger.log(System.Logger.Level.ERROR, "Exception while trying to connect to " + this.context.getConnectionName(), (Throwable)e);
        }
        finally {
            if (!this.context.isDeviceConnected()) {
                Object object = this.connectionWaiter;
                synchronized (object) {
                    try {
                        this.connectionWaiter.wait(this.connectionDelay.get());
                    }
                    catch (InterruptedException e) {
                        this.logger.log(System.Logger.Level.INFO, "Thread exiting, interrupted during wait");
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.connectionDelay.get() < 10000) {
                    this.connectionDelay.addAndGet(this.connectionDelay.get());
                }
            }
        }
    }

    @Override
    public void enterState() {
        this.connectionTask = this.context.getScheduledExecutor().scheduleAtFixedRate(this::tryConnect, 1L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitState(RemoteConnectorState nextState) {
        Object object = this.connectionWaiter;
        synchronized (object) {
            this.connectionWaiter.notify();
        }
        boolean stopped = this.connectionTask.cancel(false);
        this.logger.log(System.Logger.Level.INFO, "We are connected so stopping connection task: status = " + stopped);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.AWAITING_CONNECTION;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return false;
    }
}

