/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.BooleanMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class BooleanMenuItem
extends MenuItem<Boolean> {
    private final BooleanNaming naming;

    public BooleanMenuItem() {
        super("", -1, -1, null, false, false, true);
        this.naming = BooleanNaming.ON_OFF;
    }

    public BooleanMenuItem(String name, int id, int eepromAddress, String functionName, BooleanNaming naming, boolean readOnly, boolean localOnly, boolean visible) {
        super(name, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.naming = naming;
    }

    public BooleanNaming getNaming() {
        return this.naming;
    }

    @Override
    public MenuState<Boolean> newMenuState(Boolean value, boolean changed, boolean active) {
        return new BooleanMenuState(this, changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanMenuItem that = (BooleanMenuItem)o;
        return this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isLocalOnly() == that.isLocalOnly() && this.getNaming() == that.getNaming() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNaming(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly()});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public static enum BooleanNaming {
        ON_OFF,
        YES_NO,
        TRUE_FALSE;

    }
}

