/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.rs232;

import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.ConnectorFactory;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.NamedDaemonThreadFactory;
import com.thecoderscorner.menu.remote.RemoteMenuController;
import com.thecoderscorner.menu.remote.protocol.PairingHelper;
import com.thecoderscorner.menu.remote.protocol.TagValMenuCommandProtocol;
import com.thecoderscorner.menu.remote.rs232.Rs232RemoteConnector;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public class Rs232ControllerBuilder
implements ConnectorFactory {
    private String portName;
    private int baud;
    private ScheduledExecutorService executorService;
    private MenuTree menuTree;
    private MenuCommandProtocol protocol;
    private Clock clock = Clock.systemDefaultZone();
    private String name;
    private UUID uuid;

    public Rs232ControllerBuilder withRs232(String port, int baud) {
        this.portName = port;
        this.baud = baud;
        return this;
    }

    public Rs232ControllerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public Rs232ControllerBuilder withUUID(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public Rs232ControllerBuilder withExecutor(ScheduledExecutorService executor) {
        this.executorService = executor;
        return this;
    }

    public Rs232ControllerBuilder withMenuTree(MenuTree tree) {
        this.menuTree = tree;
        return this;
    }

    public Rs232ControllerBuilder withProtocol(MenuCommandProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Rs232ControllerBuilder withLocalName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public RemoteMenuController build() {
        this.initialiseBasics();
        Rs232RemoteConnector connector = new Rs232RemoteConnector(new LocalIdentifier(this.uuid, this.name), this.portName, this.baud, this.protocol, this.executorService, this.clock, ConnectMode.FULLY_AUTHENTICATED);
        return new RemoteMenuController(connector, this.menuTree);
    }

    private void initialiseBasics() {
        if (this.uuid == null || this.name == null) {
            throw new IllegalArgumentException("Name / UUID cannot be null (Call UUID.randomUUID() to get one)");
        }
        if (this.protocol == null) {
            this.protocol = new TagValMenuCommandProtocol();
        }
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2, new NamedDaemonThreadFactory("rs232-remote"));
        }
    }

    @Override
    public boolean attemptPairing(Optional<Consumer<AuthStatus>> maybePairingListener) {
        this.initialiseBasics();
        Rs232RemoteConnector connector = new Rs232RemoteConnector(new LocalIdentifier(this.uuid, this.name), this.portName, this.baud, this.protocol, this.executorService, this.clock, ConnectMode.PAIRING_CONNECTION);
        PairingHelper helper = new PairingHelper(connector, this.executorService, maybePairingListener);
        return helper.attemptPairing();
    }
}

